//
//  YHContractMainItemStatusCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHContractMainItemStatusCell: UITableViewCell {
    static let cellReuseIdentifier = "YHContractMainItemStatusCell"
    static let cellHeight: CGFloat = 97.0
    
    var dataModel: YHContactMainItemStatusModel? {
        didSet {
            updateUI()
        }
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var iconImageV: UIImageView = {
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "service_center_sfsq_xxws_icon")
        nextImgV.contentMode = .scaleAspectFill
        return nextImgV
    }()
    
    private lazy var itemNameLable: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor(red: 0.133, green: 0.133, blue: 0.133, alpha: 1)
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.text = "信息完善"
        return lable
    }()
    
    private lazy var goUnfinishHoldView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        
        let lable = UILabel()
        lable.font = UIFont.PFSC_M(ofSize: 13)
        lable.text = "去完善"
        lable.textAlignment = .center
        lable.textColor = .white
        view.addSubview(lable)
        lable.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        return view
    }()
    
    private lazy var gofinishHoldView: UIView = {
        let view = UIView()
        return view
    }()
    
    private var myNextImgV: UIImageView!
}

extension YHContractMainItemStatusCell {
    func updateUI() {
        gofinishHoldView.isHidden = true
        goUnfinishHoldView.isHidden = true
        myNextImgV.isHidden = true
        
        iconImageV.image = UIImage(named: dataModel?.iconName ?? "")
        itemNameLable.text = dataModel?.itemName ?? ""
        if dataModel?.type == 1 {
            gofinishHoldView.isHidden = !(dataModel?.isFinished ?? false)
            goUnfinishHoldView.isHidden = dataModel?.isFinished ?? false
        } else if dataModel?.type == 2 {
            gofinishHoldView.isHidden = !(dataModel?.isFinished ?? false)
            goUnfinishHoldView.isHidden = dataModel?.isFinished ?? false
        } else {
            myNextImgV.isHidden = false
        }
    }
    
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        
        holdView.addSubview(iconImageV)
        iconImageV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(26)
            make.width.height.equalTo(34)
        }
        
        holdView.addSubview(itemNameLable)
        itemNameLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(iconImageV.snp.right).offset(14)
            make.height.equalTo(24)
            make.width.equalTo(80)
        }
        
        holdView.addSubview(goUnfinishHoldView)
        goUnfinishHoldView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.height.equalTo(34)
            make.width.equalTo(76)
        }
        
        goUnfinishHoldView.layoutIfNeeded()
        goUnfinishHoldView.addYinHeGradualLayer()
        
        gofinishHoldView.isHidden = true
        holdView.addSubview(gofinishHoldView)
        gofinishHoldView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.width.equalTo(82)
        }
        
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "service_center_right_next_icon")
        nextImgV.contentMode = .scaleAspectFill
        gofinishHoldView.addSubview(nextImgV)
        nextImgV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalToSuperview()
            make.width.height.equalTo(20)
            
        }
        
        let statusLable = UILabel(text: "已完成")
        statusLable.textAlignment = .center
        statusLable.font = UIFont.PFSC_M(ofSize: 14)
        statusLable.textColor = UIColor.mainTextColor
        gofinishHoldView.addSubview(statusLable)
        statusLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(nextImgV.snp.left).offset(-2)
            make.height.equalTo(20)
            make.width.equalTo(42)
        }
        
        let statusIcon = UIImageView()
        statusIcon.image = UIImage(named: "service_center_finish_icon")
        statusIcon.contentMode = .scaleAspectFill
        gofinishHoldView.addSubview(statusIcon)
        statusIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(statusLable.snp.left).offset(-4)
            make.width.height.equalTo(14)
        }
        
        myNextImgV = UIImageView()
        myNextImgV.image = UIImage(named: "service_center_right_next_icon")
        myNextImgV.contentMode = .scaleAspectFill
        holdView.addSubview(myNextImgV)
        myNextImgV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.width.height.equalTo(20)
        }
    }
    
}
