//
//  YHCommonAlertView+AttributedMessage.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

extension YHCommonAlertView {
    
    static func show(title: String? = nil, attributedMessage: ASAttributedString? = nil, _ leftButtonString: String? = nil, _ rightButtonString: String? = nil, fullGuestureEnable: Bool = true, cancelCallBack: (() -> Void)? = nil, callBack: @escaping (() -> Void)) {
        let view = YHCommonAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.agreeBlock = callBack
        view.cancelBlcok = cancelCallBack
        view.setContent(title, attributedMessage?.value.string, leftButtonString, rightButtonString)
        view.messageLabel.attributed.text = attributedMessage
        view.messageLabel.lineBreakMode = .byCharWrapping
        view.isFullGuestureEnabel = fullGuestureEnable
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
}
