//
//  YHFamilyRequest.swift
//  galaxy
//
//  Created by edy on 2024/2/1.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

class YHFamilyRequestViewModel {
    
    // 请求所有家庭成员信息
     func getFamilyInfoList(orderId: Int, callBackBlock: @escaping (_ listInfo: YHFamilyMemberGroupInfo?, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Family.familyInfoApi
        let params = ["order_id": orderId]
         YHHUD.show(.progress(message: "数据加载中..."))
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            YHHUD.hide()
                         
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHFamilyMemberGroupInfo.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(nil, error)
                    return
                }
                _ = resultModel.checkDefaultValue()
                callBackBlock(resultModel, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(nil, error)
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(nil, err)
        }
    }
    
    // 添加家庭成员
    func addOrSaveFamilyMember(params: [String: Any], isShowLoading: Bool = true, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
       
        if isShowLoading {
            YHHUD.show(.progress(message: "数据加载中..."))
        }

       let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Family.familyInfoApi
       
       _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
           
           if isShowLoading {
               YHHUD.hide()
           }
           printLog("model 是 ==> \(json)")
           if json.code == 200 {
               callBackBlock(true, nil)
           } else {
               callBackBlock(false, YHErrorModel(errorCode: json.code, errorMsg: json.msg))
           }
           
       } failBlock: { err in
           if isShowLoading {
               YHHUD.hide()
           }
           callBackBlock(false, err)
       }
   }
    
    func deleteFamilyMember(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Family.deleteFamilyMemberApi
        
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            YHHUD.hide()
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                callBackBlock(false, YHErrorModel(errorCode: json.code, errorMsg: json.msg))
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false, err)
        }
    }
    // 提交所有家庭成员信息
    func submitAllFamilyInfo(orderId: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Family.submitAllFamilyInfoApi
        
        _ = YHNetRequest.postRequest(url: strUrl, params: ["order_id": orderId]) { json, _ in
            YHHUD.hide()
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                callBackBlock(false, YHErrorModel(errorCode: json.code, errorMsg: json.msg))
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false, err)
        }
    }
    
    func requestFamilyMemberInfo(orderId: Int, detailId: Int, callBackBlock: @escaping (_ detail: YHFamilyMember?, _ error: YHErrorModel?) -> Void) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Family.familyInfoDetailApi
        
        _ = YHNetRequest.getRequest(url: strUrl, params: ["order_id": orderId,
                                                             "id": detailId]) { json, _ in
            
            YHHUD.hide()
            printLog("model 是 ==> \(json)")
            YHHUD.hide()
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHFamilyMember.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(nil, error)
                    return
                }
                _ = resultModel.checkDefaultValue()
                callBackBlock(resultModel, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(nil, error)
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(nil, err)
        }
    }
    
    // memberType 只能传 父亲、母亲、配偶
    func requestFamilyMemberDetailInfo(memberType: YHFamilyMemberType, orderId: Int, callBack: ((_ detail: YHFamilyMember?) -> Void)?) {
        
        let params: [String: Any] =  ["order_id": orderId]
        self.getFamilyInfoList(orderId: orderId) {
            listInfo, _ in
            guard let callBack = callBack else { return }
            if let listInfo = listInfo {
                if memberType == .spouse {
                    callBack(listInfo.spouse)
                } else if memberType == .father {
                    callBack(listInfo.father)
                } else if memberType == .mother {
                    callBack(listInfo.mother)
                } else {
                    callBack(nil)
                }
            }
        }
    }
}
