//
//  YHNameCardDynamicCell.swift
//  galaxy
//
//  Created by Dufet on 2025/9/28.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHNameCardDynamicCell: UITableViewCell {

    static let cellReuseIdentifier = "YHNameCardDynamicCell"
    
    static let imgH: CGFloat = (KScreenWidth-20*2-4*2)/3.0
    
    private lazy var publishLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = UIColor.brandGrayColor6
        label.text = "发布了动态"
        return label
    }()
    
    private lazy var timeLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = UIColor.brandGrayColor6
        label.text = "00-00"
        label.textAlignment = .right
        return label
    }()
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 16)
        label.textColor = UIColor.brandGrayColor8
        label.numberOfLines = 2
        return label
    }()
    
    private lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 16)
        label.textColor = UIColor.brandGrayColor8
        label.numberOfLines = 2
        return label
    }()
    
    private lazy var imgContentV: UIView = {
        let v = UIView()
        return v
    }()
    
    private lazy var img1V: UIImageView = {
       let v = UIImageView()
       return v
    }()
    
    private lazy var img2V: UIImageView = {
       let v = UIImageView()
       return v
    }()
    
    private lazy var img3V: UIImageView = {
       let v = UIImageView()
       return v
    }()
    
    private lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = UIColor.brandGrayColor3
        return v
    }()
    
    private var reviewContentV: UIView = {
       let v = UIView()
        v.backgroundColor = UIColor.brandGrayColor2
       return v
    }()
    
    private lazy var rejectLabel: UILabel = {
       let label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("审核不通过：", .font(UIFont.PFSC_M(ofSize: 12)), .foreground(UIColor.failColor))
        let b: ASAttributedString = .init("", .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
        label.attributed.text = a + b
       return label
    }()
    
    private lazy var publishBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("重新发布", for: .normal)
        btn.setTitleColor(.brandGrayColor8, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 11)
        btn.layer.borderColor = UIColor.brandGrayColor8.cgColor
        btn.layer.borderWidth = 1.0
        btn.layer.cornerRadius = 12.0
        return btn
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func updateModel(_ model: YHDynamicItem) {
        timeLabel.text = model.format_release_time
        
        let test = false
        if test {
            model.is_self_posts = 1
            model.audit_status = 3
            model.violation_remark = "阿是就发了时代峰峻阿克拉生发剂拉卡萨电极法卡拉是电极法考拉手机大发卡拉季湿哒哒开发逻辑阿达山卡拉代发久啊双打卡拉法基1"
        }
        
        // 审核视图显示
        var hiddenReview = true
        if model.is_self_posts == 1 {
            if model.audit_status == 3 {
                hiddenReview = false
            }
         }
        reviewContentV.isHidden = hiddenReview
        rejectLabel.text = model.violation_remark
        if hiddenReview {
            reviewContentV.snp.remakeConstraints { make in
                make.left.right.equalTo(0)
                make.height.equalTo(0)
                make.top.equalTo(24)
                make.bottom.equalTo(publishLabel.snp.top).offset(0)
            }
            
        } else {
            reviewContentV.snp.remakeConstraints { make in
                make.left.right.equalTo(0)
                make.top.equalTo(24)
                make.bottom.equalTo(publishLabel.snp.top).offset(-16)
            }
        }
        
        // 标题显示
        titleLabel.text = model.title
        titleLabel.snp.updateConstraints { make in
            make.top.equalTo(publishLabel.snp.bottom).offset(model.title.isEmpty ? 0 : 10)
        }
        
        // 详情文字显示
        detailLabel.text = model.content
        detailLabel.snp.updateConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(model.content.isEmpty ? 0 : 10)
        }
        
        // 图片显示逻辑
        img1V.isHidden = model.resource_urls.count <= 0
        if model.resource_urls.count > 0 {
            let resource = model.resource_urls[0]
            img1V.sd_setImage(with: URL(string: resource.url), placeholderImage: UIImage(named: "global_default_image"), context: nil)
        }
        img2V.isHidden = model.resource_urls.count <= 1
        if model.resource_urls.count > 1 {
            let resource = model.resource_urls[1]
            img2V.sd_setImage(with: URL(string: resource.url), placeholderImage: UIImage(named: "global_default_image"), context: nil)
        }
        img3V.isHidden = model.resource_urls.count <= 2
        if model.resource_urls.count > 2 {
            let resource = model.resource_urls[2]
            img3V.sd_setImage(with: URL(string: resource.url), placeholderImage: UIImage(named: "global_default_image"), context: nil)
        }
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        
        contentView.addSubview(reviewContentV)
        contentView.addSubview(publishLabel)
        contentView.addSubview(timeLabel)
        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        contentView.addSubview(imgContentV)
        contentView.addSubview(lineView)
        
        imgContentV.addSubview(img1V)
        imgContentV.addSubview(img2V)
        imgContentV.addSubview(img3V)
        
        reviewContentV.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.top.equalTo(24)
        }
        
        let iconV: UIImageView = UIImageView()
        iconV.image = UIImage(named: "name_card_tips")
        reviewContentV.addSubview(iconV)
        iconV.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.top.equalTo(10)
            make.width.height.equalTo(14)
        }
        
        reviewContentV.addSubview(rejectLabel)
        rejectLabel.snp.makeConstraints { make in
            make.left.equalTo(iconV.snp.right).offset(4)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        reviewContentV.addSubview(publishBtn)
        publishBtn.snp.makeConstraints { make in
            make.right.equalTo(-8)
            make.left.equalTo(rejectLabel.snp.right).offset(8)
            make.width.equalTo(72)
            make.height.equalTo(24)
            make.centerY.equalToSuperview()
        }

        publishLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.height.equalTo(17)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.top.equalTo(publishLabel)
            make.left.equalTo(publishLabel.snp.right).offset(10)
            make.right.equalTo(0)
            make.height.equalTo(17)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.top.equalTo(publishLabel.snp.bottom).offset(10)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.top.equalTo(titleLabel.snp.bottom).offset(10)
        }
        
        imgContentV.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.height.equalTo(Self.imgH)
            make.top.equalTo(detailLabel.snp.bottom).offset(16)
            make.bottom.equalTo(-24)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.bottom.equalTo(0)
            make.height.equalTo(1)
        }
        
        img1V.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.width.equalTo(Self.imgH)
        }
        
        img2V.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(img1V.snp.right).offset(4)
            make.width.equalTo(Self.imgH)
        }
        
        img3V.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(img2V.snp.right).offset(4)
            make.width.equalTo(Self.imgH)
        }
    }

}
