//
//  YHServiceMoreAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceMoreAlertView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var centerView: UIView!
    var orderButton: UIButton!
    var guideButton: UIButton!
    var isShowGuide: Bool = false {
        didSet {
            if isShowGuide {
                guideButton.isHidden = false
                centerView.snp.remakeConstraints { make in
                    make.right.equalTo(-20)
                    make.height.equalTo(112)
                    make.width.equalTo(164)
                    make.top.equalTo(85)
                }
            } else {
                guideButton.isHidden = true
                centerView.snp.remakeConstraints { make in
                    make.right.equalTo(-20)
                    make.height.equalTo(64)
                    make.width.equalTo(164)
                    make.top.equalTo(85)
                }
            }
        }
    }
    
    static func show(_ flag: Bool = false, callBack: @escaping ((Int) -> Void)) {
        let view = YHServiceMoreAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.isShowGuide = flag
        view.block = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius3
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.height.equalTo(64)
            make.width.equalTo(164)
            make.top.equalTo(85)
        }
        
        orderButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "service_more_order"), for: .normal)
            button.setTitle("服务进度      ", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
            button.addTarget(self, action: #selector(orderButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(orderButton)
        orderButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.height.equalTo(20)
            make.width.equalTo(124)
            make.top.equalTo(24)
        }
        
        guideButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "service_more_guide"), for: .normal)
            button.setTitle("申请操作指引", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
            button.addTarget(self, action: #selector(guideButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(guideButton)
        guideButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.height.equalTo(20)
            make.width.equalTo(124)
            make.bottom.equalTo(-24)
        }
        orderButton.iconInLeft(spacing: 8)
        guideButton.iconInLeft(spacing: 8)
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func orderButtonClick() {
        if let block = block {
            block(1)
        }
        dismiss()
    }
    
    @objc func guideButtonClick() {
        if let block = block {
            block(2)
        }
        dismiss()
    }
}

extension YHServiceMoreAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
