//
//  YHHKRequiredItemView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRequiredItemView: UIView {

    var text: String = "" {
        didSet {
            titleLabel.text = text
        }
    }
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var requireView: UIView = {
        let view = UIView()
        let hookImgV = UIImageView(image: UIImage(named: "my_scheme_require_fit"))
        view.addSubview(hookImgV)
        hookImgV.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        return view
    }()
    
    lazy var topSeparaterLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xF7F2ED)
        return view
    }()
    
    lazy var verticalSeparaterLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xF7F2ED)
        return view
    }()

    override init(frame: CGRect) {
        super.init(frame: .zero)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        self.addSubview(titleLabel)
        self.addSubview(requireView)
        self.addSubview(topSeparaterLine)
        self.addSubview(verticalSeparaterLine)
        
        requireView.snp.makeConstraints { make in
            make.width.equalTo(72)
            make.right.top.bottom.equalToSuperview()
        }
        
        topSeparaterLine.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        verticalSeparaterLine.snp.makeConstraints { make in
            make.left.equalTo(requireView.snp.left)
            make.top.bottom.equalToSuperview()
            make.width.equalTo(0.5)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.top.equalTo(12)
            make.bottom.equalTo(-12)
            make.right.equalTo(requireView.snp.left).offset(-12)
        }
    }

}
