//
//  YHSetExplainView.swift
//  galaxy
//
//  Created by EDY on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSetExplainView: UIView {
    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var lineView: UIView!
    var messageLabel: UILabel!
    var topImageView: UIImageView!
    var bottomImageView: UIImageView!
    var bottomButton: UIButton!
    var type: YHSettingType? {
        didSet {
            guard let type = type else { return }
            switch type {
            case .normal: break
            case .people:
                titleLabel.text = "授权AI人脉匹配"
                messageLabel.text = "启动该功能后，您将能够使用AI人脉雷达来高效匹配新人脉，申请交换名片并成功成为好友后，双方可互相查看名片。信息准确度越高，匹配结果越精准"
                topImageView.image = UIImage(named: "set_example_people")
            case .schoolToFriend:
                titleLabel.text = "允许向好友公开您的教育经历"
                messageLabel.text = "授权开启后，您的个人主页将展示最高学历信息，仅对好友人脉开放查看权限，保护您的隐私安全"
                topImageView.image = UIImage(named: "set_example_school")
            case .workToFriend:
                titleLabel.text = "允许向好友公开您的工作经历"
                messageLabel.text = "授权开启后，您的个人主页将展示最新工作信息，仅对好友人脉开放查看权限，保护您的隐私安全"
                topImageView.image = UIImage(named: "set_example_work")
            case .schoolToStranger:
                titleLabel.text = "允许向陌生人公开您的教育经历"
                messageLabel.text = "授权开启后，您的个人主页将展示最高学历信息，仅对非好友人脉开放查看权限，保护您的隐私安全"
                topImageView.image = UIImage(named: "set_example_school")
            case .workToStranger:
                titleLabel.text = "允许向陌生人公开您的工作经历"
                messageLabel.text = "授权开启后，您的个人主页将展示最新工作信息，仅对非好友人脉开放查看权限，保护您的隐私安全"
                topImageView.image = UIImage(named: "set_example_work")
            case .companyToStrange:
                titleLabel.text = "允许公开您的公司信息"
                messageLabel.text = "授权开启后，您的公司信息将展示在资源列表，包括企业服务与企业需求"
                topImageView.image = UIImage(named: "set_example_company")
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.68)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(632)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "身份证示例模板"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(21)
            make.top.equalTo(16)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.width.height.equalTo(24)
            make.top.equalTo(16)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        topImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "service_card_id_back")
            imageView.layer.cornerRadius = kCornerRadius3
            imageView.clipsToBounds = true
            return imageView
        }()
        centerView.addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(333)
            make.height.equalTo(382)
            make.top.equalTo(73)
        }
        
        messageLabel = {
            let label = UILabel()
            label.text = "须使用二代身份证"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor50
            label.textAlignment = .left
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(topImageView.snp.bottom).offset(20)
        }
        
        bottomButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandGrayColor8
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("知道了", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(bottomButton)
        bottomButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.bottom.equalTo(-42)
            make.height.equalTo(48)
        }
//        bottomButton.layoutIfNeeded()
        
//        bottomButton.addYinHeGradualLayer()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
}

extension YHSetExplainView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
