//
//  YHSegmentView.swift
//  galaxy
//
//  Created by edy on 2024/7/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSegmentItemView: UIView {
    
    var isSelect: Bool = false {
        didSet {
            self.titleLabel.textColor = self.isSelect ? UIColor.mainTextColor : UIColor.init(hex: 0x94A3B8)
            self.indicatorView.isHidden = self.isSelect ? false : true
        }
    }
    var text: String = "" {
        didSet {
            self.titleLabel.text = text
        }
    }
    lazy var titleLabel: UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor
        label1.font = UIFont.PFSC_M(ofSize: 14)
        label1.textAlignment = .center
        return label1
    }()
    
    lazy var indicatorView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        self.addSubview(self.titleLabel)
        self.addSubview(self.indicatorView)
        self.titleLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        self.indicatorView.snp.makeConstraints { make in
            make.width.equalTo(16)
            make.height.equalTo(2)
            make.bottom.equalToSuperview()
            make.centerX.equalToSuperview()
        }

    }
}

class YHSegmentView: UIView {
    
    var selectIndex = 0
    let itemBaseTag = 9527
    var selectBlock: ((Int) -> Void)?

    var items: [String] = [] {
        didSet {
            updateUI()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateUI() {
        self.removeSubviews()
        if items.count <= 0 { return }
        let itemWidth = self.width/CGFloat(items.count)
        for (index, text) in items.enumerated() {
            let view = YHSegmentItemView(frame: CGRect(x: CGFloat(index) * itemWidth, y: 0, width: itemWidth, height: self.height))
            view.tag = itemBaseTag+index
            view.text = text
            view.isSelect = index == 0
            let tap = UITapGestureRecognizer(target: self, action: #selector(didClickItem(_:)))
            view.addGestureRecognizer(tap)
            self.addSubview(view)
        }
    }
    
    @objc func didClickItem(_ gesture: UIGestureRecognizer) {
        if let view = gesture.view as?  YHSegmentItemView {
            let selectIndex = view.tag-self.itemBaseTag
            self.selectIndex = selectIndex
            self.selectBlock?(selectIndex)
        }
    }
    
    func updateSelectIndex(_ index: Int) {
        self.selectIndex = index
        for subView in self.subviews {
            if subView is YHSegmentItemView {
                if let subItemView = subView as? YHSegmentItemView {
                    subItemView.isSelect = subItemView.tag == index+self.itemBaseTag
                }
            }
        }
    }
}
