//
//  YHVisaRenewalPayConfirmingPresenceAlertView.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHVisaRenewalPayConfirmingPresenceAlertView: UIView {
     
    var confirmBlock: (() -> Void)?
    
    var cancelBlock: (() -> Void)?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0x000000, alpha: 0.68)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var iconImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "cs_family_risk"))
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "风险提示"
        return label
    }()
    
    lazy var firstDetailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("请申请人", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("务必已进入到香港境内后，再进行确认", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.brandMainColor))
        let c: ASAttributedString = .init("，避免签证被锁", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c
        return label
    }()
    
    lazy var secondDetailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("建议入境香港后，", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("远离海关，并延迟20分钟后再进行确认", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.brandMainColor))
        let c: ASAttributedString = .init("，避免香港海关系统还未识别到入境记录!", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c
        return label
    }()
    
    lazy var confirmBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        button.setTitle("确认在港", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.addTarget(self, action: #selector(didConfirmBtnClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    lazy var cancelBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        button.setTitle("暂未在港", for: .normal)
        button.setTitleColor(UIColor.brandMainColor, for: .normal)
        button.layer.borderWidth = 1
        button.layer.borderColor = UIColor.brandMainColor.cgColor
        button.addTarget(self, action: #selector(didCancelBtnClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    static func alertView() -> YHVisaRenewalPayConfirmingPresenceAlertView {
        let view = YHVisaRenewalPayConfirmingPresenceAlertView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func didConfirmBtnClicked() {
        confirmBlock?()
        self.dismiss()
    }
    
    @objc func didCancelBtnClicked() {
        cancelBlock?()
        self.dismiss()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(firstDetailLabel)
        whiteContentView.addSubview(secondDetailLabel)
        whiteContentView.addSubview(confirmBtn)
        whiteContentView.addSubview(cancelBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(53)
            make.top.equalTo(30)
            make.centerX.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView.snp.bottom).offset(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        firstDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
        }
        
        secondDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(firstDetailLabel.snp.bottom).offset(8)
        }
        
        cancelBtn.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.bottom.equalTo(-16)
            make.height.equalTo(45)
            make.top.equalTo(secondDetailLabel.snp.bottom).offset(21)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.top.bottom.equalTo(cancelBtn)
            make.left.equalTo(cancelBtn.snp.right).offset(10)
            make.right.equalTo(-21)
            make.height.equalTo(45)
            make.width.equalTo(cancelBtn)
        }
    }
}
