//
//  YHDocListCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDocListCell: UITableViewCell {
    var centerView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 16)
        label.textColor = UIColor.mainTextColor
        label.lineBreakMode = .byWordWrapping
        label.numberOfLines = 0
        return label
    }()
    
    var statusLabel: UILabel!
    
    lazy var statusHoldView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var checkButton: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.setImage(UIImage(named: "my_doc_check_btn_0"), for: .normal)
        button.setImage(UIImage(named: "my_doc_check_btn_1"), for: .selected)
        button.addTarget(self, action: #selector(clickCheckBtn), for: .touchUpInside)
        button.isUserInteractionEnabled = false
        return button
    }()
    
    var dataSourceForSign: YHMySignatureModel? {
        didSet {
            updateAllViewsForSign()
        }
    }
    
    var dataSourceForDocs: YHMyDocumentsListModel? {
        didSet {
            updateAllViewsForDocs()
        }
        
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.top.equalTo(14)
            make.bottom.equalToSuperview()
        }
        
        centerView.addSubview(statusHoldView)
        statusHoldView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.height.equalTo(20)
            make.width.equalTo(62)
        }
        
        let imageV: UIImageView = UIImageView()
        imageV.image = UIImage(named: "my_doc_right_arrow")
        statusHoldView.addSubview(imageV)
        imageV.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.height.equalTo(kMargin)
        }
        
        statusLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.brandMainColor
            label.textAlignment = .right
            label.text = "待审核"
            return label
        }()
        
        statusHoldView.addSubview(statusLabel)
        statusLabel.snp.makeConstraints { make in
            make.right.equalTo(imageV.snp.left).offset(-4)
            make.centerY.equalToSuperview()
            make.width.equalTo(42)
            make.height.equalTo(20)
        }
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.left.equalTo(21)
            make.right.equalTo(-90)
            make.bottom.equalTo(-22)
        }
        
        centerView.addSubview(checkButton)
        checkButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-kMargin)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(kMargin)
        }
        checkButton.isHidden = true
    }
    
    // 文书状态
    func updateAllViewsForDocs() {
        guard let dataSource = dataSourceForDocs else { return }
        titleLabel.text = dataSource.doc_type_name
        if dataSource.isEditFlag {
            checkButton.isHidden = false
            statusHoldView.isHidden = true
            checkButton.isSelected = dataSource.isSelectedFlag
        } else {
            checkButton.isHidden = true
            statusHoldView.isHidden = false
            var statusTxt = "--"
            var color: UIColor = .failColor
            
            if dataSource.document.status == 6 && dataSource.sign_doc.id > 0 && dataSource.sign_doc.status > 2 {
               // 签字状态
               let status = dataSource.sign_doc.status
               if status == 3 {
                   statusTxt = "待签章"
                   color = UIColor.brandMainColor
               } else if status == 4 {
                   statusTxt = "已签章"
                   color = UIColor.successColor
               } else if status == 5 {
                   statusTxt = "已完成"
                   color = UIColor.labelTextColor2
               } else if status == 6 {
                   statusTxt = "已驳回"
                   color = UIColor.failColor
               } else {
                   statusTxt = "--"
                   color = UIColor.failColor
               }
           } else {
               // 文书状态
               let status = dataSource.document.status
               if status == 2 {
                   statusTxt = "待确认"
                   color = UIColor.brandMainColor
               } else if status == 3 {
                   statusTxt = "已提交"
                   color = UIColor.warnColor
               } else if status == 4 {
                   statusTxt = "已提交"
                   color = UIColor.warnColor
               } else if status == 5 {
                   statusTxt = "已驳回"
                   color = UIColor.failColor
               } else if status == 6 {
                   statusTxt = "已定稿"
                   color = UIColor.labelTextColor2
               } else {
                   statusTxt = "--"
                   color = UIColor.failColor
               }
               
           }
            
//
//            if dataSource.file_type.contains("sign", caseSensitive: true) {
//                let status = dataSource.sign_doc.status
//                if status == 3 {
//                    statusTxt = "待签章"
//                    color = UIColor.brandMainColor
//                } else if status == 4 {
//                    statusTxt = "已签章"
//                    color = UIColor.successColor
//                } else if status == 5 {
//                    statusTxt = "已完成"
//                    color = UIColor.labelTextColor2
//                } else if status == 6 {
//                    statusTxt = "已驳回"
//                    color = UIColor.failColor
//                } else {
//                    statusTxt = "--"
//                    color = UIColor.failColor
//                }
//            } else if dataSource.file_type.contains("doc", caseSensitive: true) {
//                let status = dataSource.status
//                if status == 2 {
//                    statusTxt = "待确认"
//                    color = UIColor.brandMainColor
//                } else if status == 3 {
//                    statusTxt = "核对中"
//                    color = UIColor.warnColor
//                } else if status == 4 {
//                    statusTxt = "核对中"
//                    color = UIColor.warnColor
//                } else if status == 5 {
//                    statusTxt = "已驳回"
//                    color = UIColor.failColor
//                } else if status == 6 {
//                    statusTxt = "已定稿"
//                    color = UIColor.labelTextColor2
//                } else {
//                    statusTxt = "--"
//                    color = UIColor.failColor
//                }
//            } else {
//                statusTxt = "--"
//                color = UIColor.failColor
//                
//            }
            
            statusLabel.text = statusTxt
            statusLabel.textColor = color
        }
    }
    
    // 签字状态
    func updateAllViewsForSign() {
        guard let dataSource = dataSourceForSign else { return }
        titleLabel.text = dataSource.doc_type_name
        if dataSource.isEditFlag {
            checkButton.isHidden = false
            statusHoldView.isHidden = true
            checkButton.isSelected = dataSource.isSelectedFlag
        } else {
            checkButton.isHidden = true
            statusHoldView.isHidden = false
            /*
             statusOpt: {
                         3: '待签章',
                         4: '已签章',
                         5: '已完成',
                         6: '已驳回'
                     },
             */
            var statusTxt = ""
            var color: UIColor = .brandMainColor
            
            let status = dataSource.status
            if status == 3 {
                statusTxt = "待签章"
                color = UIColor.brandMainColor
            } else if status == 4 {
                statusTxt = "已签章"
                color = UIColor.successColor
            } else if status == 5 {
                statusTxt = "已完成"
                color = UIColor.labelTextColor2
            } else if status == 6 {
                statusTxt = "已驳回"
                color = UIColor.failColor
            } else {
                statusTxt = "--"
                color = UIColor.failColor
            }
            statusLabel.text = statusTxt
            statusLabel.textColor = color
        }
        
    }
}

extension YHDocListCell {
    
    @objc func clickCheckBtn() {
        
    }
}
