//
//  YHSignSuccessActivity.swift
//  galaxy
//
//  Created by Dufet on 2025/10/15.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHSignGift: SmartCodable {
    
    var name: String = ""
    var url: String = ""

    required init() {
        
    }
}

class YHSignUser: SmartCodable {
    var name: String = ""
    var mobile: String = ""
    var number: Int = 0

    required init() {
        
    }
}

class YHSignSuccessActivity: SmartCodable {
    
    var place: String = ""
    var name: String = ""
    var guidance: String = ""
    var cover: String = ""
    var beginTime: String = ""
    var endTime: String = ""
    var gift: YHSignGift?
    var user: YHSignUser?
    
    var formatTime: String = ""
    
    required init() {
        
    }
    
    func getDateString(format: String = "MM/dd") -> String {
        if formatTime.isEmpty {
            if let tttt =  beginTime.double() {
                // 1.
                // 将时间戳转换为Date对象
                let date = Date(timeIntervalSince1970: TimeInterval(tttt))

                // 创建一个DateFormatter实例
                let dateFormatter = DateFormatter()

                // 设置日期格式，这里设置为"年-月-日 时:分:秒"
                dateFormatter.dateFormat = format // HH:mm:ss

                // 使用DateFormatter将Date对象转换为字符串
                let dateString = dateFormatter.string(from: date)
                
                dateFormatter.dateFormat = "HH:mm"
                let titmeString = dateFormatter.string(from: date)

                // 获取Calendar的当前实例
                let calendar = Calendar.current

                // 使用Calendar来获取星期几
                let weekday = calendar.component(.weekday, from: date)

                // 星期几的名称，根据weekday的值，1到7分别代表周一到周日
                if weekday > 0 && weekday < 8 {
                    let weekdayName = ["周日", "周一", "周二", "周三", "周四", "周五", "周六"][weekday - 1]
                    if let tttt =  endTime.double() {
                        // 将时间戳转换为Date对象
                        let date2 = Date(timeIntervalSince1970: TimeInterval(tttt))
                        let titmeString2 = dateFormatter.string(from: date2)
                        
                        if titmeString.contains(titmeString2) {
                            formatTime = dateString + " " + weekdayName + " " + titmeString
                        } else {
                            formatTime = dateString + " " + weekdayName + " " + titmeString + "-" + titmeString2
                        }

                    }
                }
            }
        }
        
        return formatTime
    }
}
