//
//  YHActivityViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHActivityHelpModel: SmartCodable {
    var type: Int = 0 // 0-详情头 1-详情内容 2-详情tips
    
    // 活动详情内容
    var activityDetailModel: YHActivityDetailModel?
    
    required init() {
    }
}

class ActiticyIdModel: SmartCodable {
    var yh_id: String = ""
    required init() {
        
    }
}

class YHActivityViewModel: YHBaseViewModel {
    // 1、活动列表 、 我的报名活动列表
    var hasMoreForActivityList: Bool = true
    var isRequestActivityListDataFlag: Bool = false
    private var curPageIndex: Int = 1
    private var page_Size: Int = 20
    private var totalCount: Int = 0
    var arrActivityListData: [YHActivityModel] = []
    
    // 2.活动详情
    var activityDetailModel: YHActivityDetailModel?
    var arrActivityDetail: [YHActivityHelpModel] = []
    
    // 3.活动报名
    var travelModel: YHTravelModel?
    
    // 4.活动行程单
    var activityTravelModel: YHActivityTravelModel?
    
    //  签到活动
    var signActivityModel: YHSignSuccessActivity?
    
}

extension YHActivityViewModel {
    
    /*
     *取消活动报名
     */
    func cancelActivityTravel(travelId: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.cancelApi
        let param = ["id": travelId]
        _ = YHNetRequest.putRequest(url: strUrl, params: param) { [weak self] json, _ in
            guard let self = self else { return }
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    /*
     *活动行程单
     */
    func getActivityTravelDetail(travelId: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.travelApi + "/" + travelId
    
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            guard let self = self else { return }
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHActivityTravelModel.deserialize(from: dic) else {
                    self.activityTravelModel = nil
                    callBackBlock(false, nil)
                    return
                }
                self.activityTravelModel = result
                callBackBlock(true, nil)
            } else {
                self.activityTravelModel = nil
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.activityTravelModel = nil
            callBackBlock(false, err)
        }
    }
    
    /*
     *活动报名
     */
    func applyActivity(param: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.applyApi
    
        _ = YHNetRequest.postRequest(url: strUrl, params: param) { [weak self] json, _ in
            guard let self = self else { return }
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHTravelModel.deserialize(from: dic) else {
                    self.travelModel = nil
                    callBackBlock(false, nil)
                    return
                }
                self.travelModel = result
                callBackBlock(true, nil)
            } else {
                self.travelModel = nil
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.travelModel = nil
            callBackBlock(false, err)
        }
    }
    
    /*
     *活动详情
     */
    func getActivityDetailData(activityID: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.detailApi + "/" + activityID
    
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            guard let self = self else { return }
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHActivityDetailModel.deserialize(from: dic) else {
                    self.arrActivityDetail = []
                    callBackBlock(false, nil)
                    return
                }
                self.activityDetailModel = result
                self.activityDetailModel?.getImageInfo()
                
                self.arrActivityDetail.removeAll()
                
                let model0 = YHActivityHelpModel()
                model0.activityDetailModel = result
                self.arrActivityDetail.append(model0)
                
                if result.introduce.isEmpty && result.posters.count < 1 {
                } else {
                    let model1 = YHActivityHelpModel()
                    model1.type = 1
                    model1.activityDetailModel = result
                    self.arrActivityDetail.append(model1)
                }
                
                if !result.tips.isEmpty {
                    let model2 = YHActivityHelpModel()
                    model2.type = 2
                    model2.activityDetailModel = result
                    self.arrActivityDetail.append(model2)
                }
                callBackBlock(true, nil)
            } else {
                self.arrActivityDetail = []
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.arrActivityDetail = []
            callBackBlock(false, err)
        }
    }
    
    /*
     *活动列表
     firstFlag  true - 首次  false - 更多
     type 0-活动列表  1-我的报名活动列表
     */
    func getActivityList(firstFlag: Bool, type: Int = 0, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        if firstFlag == false {
            guard hasMoreForActivityList == true  else {
                printLog("无更多数据可请求")
                return
            }
        }
        
        guard isRequestActivityListDataFlag == false else {
            printLog("正在进行请求")
            return
        }
        
        isRequestActivityListDataFlag = true
        
        var params: [String: Any] = ["page": curPageIndex,
                                      "page_size": page_Size]
        if firstFlag {
            params = ["page": 1,
                      "page_size": page_Size]
        } else {
            params = ["page": curPageIndex + 1,
                      "page_size": page_Size]
        }
        var strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.listApi
        if type == 1 {
            strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.myListApi
        } else if  type == 0 {
            
        }
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            
            self.isRequestActivityListDataFlag = false
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHActivityListModel.deserialize(from: dic) else {
                    self.arrActivityListData = []
                    callBackBlock(false, nil)
                    return
                }
                
                if firstFlag {
                    self.totalCount = Int(result.total) ?? 0
                    self.arrActivityListData = result.data
                    curPageIndex = 1
                } else {
                    curPageIndex += 1
                    self.arrActivityListData.append(contentsOf: result.data)
                }
                
                if result.data.count >= page_Size {
                    if self.arrActivityListData.count >= self.totalCount {
                        self.hasMoreForActivityList = false
                    } else {
                        self.hasMoreForActivityList = true
                    }
                } else {
                    self.hasMoreForActivityList = false
                }
                
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.isRequestActivityListDataFlag =  false
            callBackBlock(false, err)
        }
    }
    
    func getActiticyYhId(callback: @escaping (String) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Resource.yhManagerId + "?mode=2"
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = ActiticyIdModel.deserialize(from: dic) else {
                    return
                }
                callback(result.yh_id)
            } else {
                callback("")
            }
        } failBlock: { _ in
            callback("")
        }
        
    }
    
    func getActivitySign(id: String, callback: @escaping (Bool) -> Void) {
        
        let params: [String: Any] =  [
            "activityId": id,
            "appId": 1
        ]
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Activity.sign
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHSignSuccessActivity.deserialize(from: dic) else {
                    self.signActivityModel = nil
                    callback(false)
                    return
                }
                self.signActivityModel = result
                callback(true)
                
            } else {
                self.signActivityModel = nil
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callback(false)
            }
        } failBlock: { _ in
            self.signActivityModel = nil
            callback(false)
        }
    }
}
