//
//  YHEducationMarkView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEducationMarkView: UIView {
    
    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }

    var dotView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xB3C8E9)
        view.layer.cornerRadius = 1.0
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(dotView)
        self.addSubview(titleLabel)
        
        dotView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(8)
            make.width.height.equalTo(5)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(dotView.snp.right).offset(10)
            make.top.right.bottom.equalToSuperview()
        }
    }
}
