//
//  YHWorkExperiencePositionReasonTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHWorkExperiencePositionReasonTableViewCell: UITableViewCell {
    typealias SelectBlock = (_ selectIndex: [Int]) -> Void
    var selectBlock: SelectBlock?
    var selectItem: [Int] = []
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var lineView: UIView!
    var mainItemView: UIView!
    
    var dataSource: [ASAttributedString]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "证件提供确认"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            let str = "*" + "您可以提供以下哪种工作证明文件："
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 14),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(52)
            make.right.equalTo(-18)
        }
        
        lineView = {
            let label = UIView()
            label.backgroundColor = UIColor.separatorColor
            return label
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.height.equalTo(1)
            make.top.equalTo(52)
            make.left.right.equalToSuperview()
        }
    
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-16)
            make.top.equalTo(104)
        }
        
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        for i in 0 ..< (dataSource?.count ?? 0) {
            let bgviewButton = {
                let view = UIButton()
                view.backgroundColor = UIColor.contentBkgColor
                view.layer.cornerRadius = 3
                view.layer.borderColor = UIColor.brandMainColor.cgColor
                view.addTarget(self, action: #selector(agreeClick(sender:)), for: .touchUpInside)
                view.tag = 20000 + i
                if selectItem.contains(i) {
                    view.layer.borderWidth = 1
                    view.backgroundColor = UIColor(hex: 0xebf0f9)
                } else {
                    view.layer.borderWidth = 0
                    view.backgroundColor = UIColor.contentBkgColor
                }
                return view
            }()
            mainItemView.addSubview(bgviewButton)

            let agreeButton = {
                let button = UIImageView()
                button.image = UIImage(named: "service_privacy_disagree_glay")
                button.tag = 10000 + i
                if selectItem.contains(i) {
                    button.image = UIImage(named: "service_privacy_agree")
                } else {
                    button.image = UIImage(named: "service_privacy_disagree_glay")
                }
                button.isUserInteractionEnabled = false

                return button
            }()
            mainItemView.addSubview(agreeButton)
            agreeButton.snp.makeConstraints { make in
                if i == 0 {
                    make.top.equalToSuperview().offset(16)
                } else {
                    let view = mainItemView.viewWithTag(1000 + i - 1)
                    make.top.equalTo(view?.snp.bottom ?? mainItemView.snp.bottom).offset(48)
                }
                make.left.equalTo(34)
                make.height.equalTo(13)
                make.width.equalTo(13)
            }
            
            let subTitleLabel = {
                let label = UILabel()
                label.attributed.text = dataSource?[i]
                label.numberOfLines = 0
                label.tag = 1000 + i
                label.isUserInteractionEnabled = false
                return label
            }()
            mainItemView.addSubview(subTitleLabel)
            subTitleLabel.snp.makeConstraints { make in
                make.top.equalTo(agreeButton.snp.top).offset(-3)
                make.left.equalTo(56)
                make.right.equalTo(-35)
                if i == (dataSource?.count ?? 0) - 1 && !selectItem.contains(6) {
                    make.bottom.equalToSuperview().offset(-16)
                }
            }
            
            bgviewButton.snp.makeConstraints { make in
                make.top.equalTo(subTitleLabel.snp.top).offset(-16)
                make.bottom.equalTo(subTitleLabel.snp.bottom).offset(16)
                make.left.equalTo(18)
                make.right.equalTo(-18)
            }
        }
    }
    
    @objc func agreeClick(sender: UIButton) {
        selectItem.removeAll()
        selectItem.append(sender.tag - 20000)
        sender.isSelected = !sender.isSelected
        for i in 0..<(dataSource?.count ?? 0) {
            if i == sender.tag - 20000 {
                let view = mainItemView.viewWithTag(i + 20000)
                view?.layer.borderWidth = 1
                view?.backgroundColor = UIColor(hex: 0xebf0f9)
                guard let subview = mainItemView.viewWithTag(i + 10000) as? UIImageView else { return }
                subview.image = UIImage(named: "service_privacy_agree")
            } else {
                let view = mainItemView.viewWithTag(i + 20000)
                view?.layer.borderWidth = 0
                view?.backgroundColor = UIColor.contentBkgColor
                guard let subview = mainItemView.viewWithTag(i + 10000) as? UIImageView else { return }
                subview.image = UIImage(named: "service_privacy_disagree_glay")
            }
        }
    
        if let block = selectBlock {
            block(selectItem)
        }
    }
    
}
