//
//  YHPlanCustomerCaseListCell.swift
//  galaxy
//
//  Created by Dufet on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanCustomerCaseListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHPlanCustomerCaseListCell"
    
    var clickBlock: (([YHPlanCaseModel], Int) -> Void)?
    var cases: [YHPlanCaseModel] = [] {
        didSet {
            collectionView.reloadData()
        }
    }
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x8993A2)
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "客户案例"
        return lable
    }()
    
    lazy var collectionView: UICollectionView = {
        let layout = YHPlanCustomerCaseListLayout()
        let collectView = UICollectionView(frame: .zero, collectionViewLayout: layout)
        collectView.backgroundColor = .clear
        collectView.delegate = self
        collectView.dataSource = self
        collectView.register(YHPlanCustomerCaseCollectionCell.self, forCellWithReuseIdentifier: YHPlanCustomerCaseCollectionCell.cellReuseIdentifier)
        collectView.isScrollEnabled = false
        return collectView
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        let leftLine = UIView()
        leftLine.backgroundColor = .init(hex: 0xD5DAE1)
        contentView.addSubview(leftLine)
        
        let rightLine = UIView()
        rightLine.backgroundColor = .init(hex: 0xD5DAE1)
        contentView.addSubview(rightLine)

        contentView.addSubview(titleLabel)
        contentView.addSubview(collectionView)
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.centerX.equalToSuperview()
            make.width.equalTo(70)
            make.height.equalTo(20)
        }
        
        leftLine.snp.makeConstraints { make in
            make.width.equalTo(50)
            make.height.equalTo(0.5)
            make.right.equalTo(titleLabel.snp.left)
            make.centerY.equalTo(titleLabel)
        }
        
        rightLine.snp.makeConstraints { make in
            make.width.equalTo(50)
            make.height.equalTo(0.5)
            make.left.equalTo(titleLabel.snp.right)
            make.centerY.equalTo(titleLabel)
        }
        
        collectionView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.bottom.equalToSuperview()
        }
    }
}

extension YHPlanCustomerCaseListCell: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout, YHPlanCustomerCaseListLayoutDelegate {
    
        // 返回单元格数量
        func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
            
            return cases.count
        }
        
        // 返回每个单元格的大小
        func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
            
            let cellWidth = floor((KScreenWidth-16.0*2.0-10.0)/2.0)
            var height = 0.0
            if indexPath.item < cases.count {
                let model = cases[indexPath.item]
                height = self.getHeigt(font: UIFont.PFSC_R(ofSize: 14), width: cellWidth-8.0*2.0, string: model.title)
            }
            
            height += (cellWidth*(200.0/166.0) + 8.0+12.0+10.0)
            return CGSize(width: cellWidth, height: height)
        }
        
        // 返回自定义单元格
        func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
            guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHPlanCustomerCaseCollectionCell.cellReuseIdentifier, for: indexPath) as? YHPlanCustomerCaseCollectionCell else {
                return UICollectionViewCell()
            }
            if 0 <= indexPath.item && indexPath.item < cases.count {
                let model = cases[indexPath.item]
                cell.model = model
            }
            return cell
        }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if 0 <= indexPath.item && indexPath.item < cases.count {
//            let text = topicArr[indexPath.item]
            clickBlock?(cases, indexPath.item)
        }
    }
    
    // 计算文字宽度大小
    func getHeigt(font: UIFont, width: CGFloat, string: String) -> CGFloat {
        let size = CGSize.init(width: width, height: CGFloat(MAXFLOAT))
        let dic = [NSAttributedString.Key.font: font] // swift 4.2
        let strSize = string.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return ceil(strSize.height)
    }
}
