//
//  YHInformationAuthorizeViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInformationAuthorizeViewModel: YHBaseViewModel {
    var setModel: YHMainUserInformationSetModel = YHMainUserInformationSetModel()
    var model: YHUserInformationDetailModel = YHUserInformationDetailModel()
    override init() {
        super.init()
    }
    
    func getBaseDataSource() -> [YHUserInformationModel] {
        let item1 = YHUserInformationModel(id: .id1, title: "真实姓名", isUserKeyBoard: true, prompts: "请输入您的真实姓名", message: model.username, isNeed: false)
        let item2 = YHUserInformationModel(id: .id6, title: "所在地", isUserKeyBoard: false, prompts: "请选择您的所在地", message: model.address.country, type: .country, isNeed: false)
        var string = ""
        if model.address.province.count != 0 {
            string = model.address.province + "/" + model.address.city
        }
         
        let item3 = YHUserInformationModel(id: .id2, title: "所在地-省市", isUserKeyBoard: false, prompts: "请选择您的所在地", message: string, type: .address, isNeed: false)
        let item4 = YHUserInformationModel(id: .id3, title: "毕业院校", isUserKeyBoard: true, prompts: "请输入您的毕业院校", message: model.college, isNeed: false)
        let item5 = YHUserInformationModel(id: .id4, title: "所属行业", isUserKeyBoard: false, prompts: "请选择您的所属行业", message: model.industry, type: .id, isNeed: false)
        let item6 = YHUserInformationModel(id: .id5, title: "职位", isUserKeyBoard: true, prompts: "请输入您的职位", message: model.position, isNeed: false)
        if model.address.country.contains("中国") {
            return [item1, item2, item3, item4, item5, item6]
        }
        return [item1, item2, item4, item5, item6]
    }
    
    func updateModel(_ item: YHUserInformationModel) {
        guard let type = item.id else { return }
        switch type {
        case .id1:
            model.username = item.message ?? ""
        case .id2:
            model.address.province = item.value?.first ?? ""
            model.address.city = item.value?.last ?? ""
        case .id3:
            model.college = item.message ?? ""
        case .id4:
            model.industry = item.message ?? ""
        case .id5:
            model.position = item.message ?? ""
        case .id6:
            model.address.country = item.message ?? ""
        default:
            break
        }
    }
    
    func isCanNext() -> Bool {
        let username = model.username
        let school = model.college
        let country = model.address.country
        let provice = model.address.province
        let city = model.address.city
        let industry = model.industry
        let position = model.position
        guard username.count > 0 else { return false }
        guard school.count > 0 else { return false }
        guard industry.count > 0 else { return false }
        guard position.count > 0 else { return false }
        guard country.count > 0 else { return false }
        if model.address.country.contains("中国") {
            guard provice.count > 0 else { return false }
            guard city.count > 0 else { return false }
        }
        return true
    }

    func getBaseSetDataSource() -> [YHSettingItem] {
        let item1 = YHSettingItem(type: .people, title: "授权AI人脉匹配", subTitle: "开启后，您的信息将用于AI人脉匹配，为您构建高质量的人脉网络", isSelect: setModel.authorization_basic_information == 2 ? true : false, isShowAlert: true)
        let item2 = YHSettingItem(type: .school, title: "允许向好友公开您的教育经历", subTitle: "开启后，您的教育经历将在您的个人名片上对已交换名片的好友可见", isSelect: setModel.public_education_experience == 2 ? true : false, isShowAlert: true)
        let item3 = YHSettingItem(type: .work, title: "允许向好友公开您的工作经历", subTitle: "开启后，您的工作经历将在您的个人名片上对已交换名片的好友可见", isSelect: setModel.public_work_experience == 2 ? true : false, isShowAlert: true)
        return [item1, item2, item3]
    }
    
    func updateSetModel(_ item: YHSettingItem) {
        switch item.type {
        case .normal: break
            
        case .people:
            setModel.authorization_basic_information = item.isSelect ? 2 : 1
        case .school:
            setModel.public_education_experience = item.isSelect ? 2 : 1
        case .work:
            setModel.public_work_experience = item.isSelect ? 2 : 1
        }
    }
    
    func requestUserInfo(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.userInfoApi
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHUserInformationDetailModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.model = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestUserAuthorization(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.userAuthorization
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHMainUserInformationSetModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.setModel = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSaveUserInfo(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let username = model.username.trimmingCharacters(in: .whitespaces)
        if username.count == 0 {
            YHHUD.flash(message: "名字不合法")
            return
        }
        let address: [String: Any] = ["country": model.address.country,
                                      "province": model.address.province,
                                      "city": model.address.city]
        let params: [String: Any] = ["avatar": model.avatar,
                                     "username": username,
                                     "college": model.college,
                                     "industry": model.industry,
                                     "position": model.position,
                                     "address": address]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.userSubmit
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestChangeHead(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.change
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHChangeHeadModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.model.avatar = result.avatar
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

    func requestAuthorizationSubmit(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["authorization_basic_information": setModel.authorization_basic_information,
                                     "public_education_experience": setModel.public_education_experience,
                                     "public_work_experience": setModel.public_work_experience]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.authorizationSubmit
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestInformationToCardSubmit(agress: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["information_to_card": agress,
                                     "isclick_card": 2]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.authorizationSubmit
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestBusinessCardAuthorize(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.businessCardAuthorize
        _ = YHNetRequest.postRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
