//
//  YHHKVisaRenewalPaymentList.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
import SmartCodable

class YHHKVisaRenewalPaymentList: SmartCodable {
    var payment_url: String = ""
    var list: [YHHKVisaRenewalPaymentItem] = []
    var evisa_example_url: String = ""
    required init() {
    }
}

class YHHKVisaRenewalPaymentItem: SmartCodable {
    // 用户id
    var id: Int = 0

    // 用户类型 主申请人-applicant 配偶-spouse 孩子-child 母亲-mother 父亲-father 兄弟姐妹-brother
    var type: String = ""

    // 用户姓名
    var name: String = ""

    // 确认赴港状态 0-未获批 1-已获批未确认在港 2-已获批已确认在港
    var confirm_hk_status: Int = 0

    // 档案号
    var file_num: String = ""

    // 可缴费开始参考时间
    var min_pay_time: String = ""

    // 可缴费结束参考时间
    var max_pay_time: String = ""

    // 缴费金额港币
    var fee_hkd: Int = 0

    // 缴费金额人民币
    var fee_rmb: String = ""

    // 支付状态 7-待缴费 8-已缴费 9-已过期 10-待获批
    var pay_status: Int = 0

    // 电子签证地址
    var receipt: String = ""
    // 缴费金额,2025-2-26之后的用区间
    var fee_money: String = ""

    required init() {
    }
}
