//
//  YHVisaRenewalPayOccupyingSpaceCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalPayOccupyingSpaceCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHVisaRenewalPayOccupyingSpaceCell"
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(isBottom: Bool = false) {
        subContainerView.corner = isBottom ? [.bottomLeft, .bottomRight] : .none
        let height: CGFloat = isBottom ? 18 : 12
        subContainerView.snp.remakeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(height).priority(.high)
        }
    }
}

extension YHVisaRenewalPayOccupyingSpaceCell {
    
    private func setupUI() {
        subContainerView.radius = 6
        updateCellCorner(.mid)
    }
}
