//
//  YHResignGuidelinesExampleShareViewController.swift
//  galaxy
//
//  Created by EDY on 2024/9/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Photos

class YHResignGuidelinesExampleShareViewController: YHBaseViewController {
    var bottomView: UIView!
    var leftButton: YHShareButton!
    var centerButton: YHShareButton!
    var rightButton: YHShareButton!
    var centerImageView: UIImageView!
    var imageView: UIImageView!
    var logoImageView: UIImageView!
    var centerImageName: String = ""
    var url: String = YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/evaluation?channel=lkhtj-app&customer_id=\(YHLoginManager.shared.userModel?.id ?? "")&scene_id=30"
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        loadData()
    }
}

extension YHResignGuidelinesExampleShareViewController {
    func getData() {
        
    }
    
    func updateDataSource() {
        
    }
    
    func setView() {
        view.backgroundColor = .contentBkgColor
        gk_navTitle = "分享活动"
        
        bottomView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(148)
        }
        
        leftButton = {
            let button = YHShareButton()
            button.setContent("invitation_with_gifts_share_left", "保存海报")
            button.addTarget(self, action: #selector(saveBtnClick), for: .touchUpInside)
            return button
        }()
        bottomView.addSubview(leftButton)
        leftButton.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.left.equalTo(42)
            make.height.equalTo(74)
            make.width.equalTo(52)
        }
        
        centerButton = {
            let button = YHShareButton()
            button.setContent("invitation_with_gifts_share_center", "微信好友")
            button.addTarget(self, action: #selector(wxClick), for: .touchUpInside)
            return button
        }()
        bottomView.addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.centerX.equalToSuperview()
            make.height.equalTo(74)
            make.width.equalTo(52)
        }
        
        rightButton = {
            let button = YHShareButton()
            button.setContent("invitation_with_gifts_share_right", "朋友圈")
            button.addTarget(self, action: #selector(peopleClick), for: .touchUpInside)
            return button
        }()
        bottomView.addSubview(rightButton)
        rightButton.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.right.equalTo(-42)
            make.height.equalTo(74)
            make.width.equalTo(52)
        }
        
        centerImageView = {
            let view = UIImageView()
            return view
        }()
        view.addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 46.fix)
            make.centerX.equalToSuperview()
            make.height.equalTo(466)
            make.width.equalTo(270)
        }
        
        imageView = {
            let view = UIImageView()
            return view
        }()
        centerImageView.addSubview(imageView)
        imageView.snp.makeConstraints { make in
            make.bottom.equalTo(-18)
            make.right.equalTo(-18)
            make.width.height.equalTo(77)
        }
        
        logoImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "share_icon")
            return view
        }()
        imageView.addSubview(logoImageView)
        logoImageView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.height.equalTo(21)
        }
        centerImageView.kf.setImage(with: URL(string: centerImageName))
        let qrString = url
        if let qrCode = qrString.generateQRCode() {
            // 可以将qrCode设置为UIImageView的image属性来显示二维码
            imageView.image = qrCode
        }
    }
    
    func loadData() {

    }
    
    @objc func saveBtnClick() {
        guard let combinedImage = combinedImageFrom(imageView: centerImageView) else { return }
        saveImageToPhotosAlbum(image: combinedImage)
    }
    
    func saveImageToPhotosAlbum(image: UIImage) {
        // 确保应用有权访问相册
        PHPhotoLibrary.requestAuthorization { status in
            if status == .authorized {
                // 保存图片到相册
                DispatchQueue.main.async {
                    UIImageWriteToSavedPhotosAlbum(image, nil, nil, nil)
                    YHHUD.flash(message: "保存成功")
                }
            } else {
                DispatchQueue.main.async {
                    YHHUD.flash(message: "保存失败，请检查系统权限")
                }
            }
        }
    }
    
    @objc func wxClick() {
        YHShareManager.shared.sendLinkContent("香港身份测评专属方案，限时领取！", "银河身份规划专家1V1评估，获取香港身份方案", UIImage(named: "resign_guidelines_example_share_other") ?? UIImage(), link: YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/evaluation?channel=lkhtj-app&customer_id=\(YHLoginManager.shared.userModel?.id ?? "")&scene_id=30")
    }
    
    @objc func peopleClick() {
        YHShareManager.shared.sendLinkContent("香港身份测评专属方案，限时领取！", "银河身份规划专家1V1评估，获取香港身份方案", UIImage(named: "resign_guidelines_example_share_other") ?? UIImage(), link: YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/evaluation?channel=lkhtj-app&customer_id=\(YHLoginManager.shared.userModel?.id ?? "")&scene_id=30", WXSceneTimeline)

    }
    
    func combinedImageFrom(imageView: UIImageView) -> UIImage? {
        UIGraphicsBeginImageContextWithOptions(imageView.bounds.size, false, 0.0)
        // 首先绘制 imageView 的内容
        imageView.layer.render(in: UIGraphicsGetCurrentContext()!)
        // 获取合成后的图像
        let combinedImage = UIGraphicsGetImageFromCurrentImageContext()

        // 结束绘图上下文
        UIGraphicsEndImageContext()

        return combinedImage
    }
    
    func currentPage(collectionView: UICollectionView) -> Int {
        let pageWidth = collectionView.frame.width
        let offset = collectionView.contentOffset
        return Int(offset.x / pageWidth)
    }
}
