//
//  YHScanViewController.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/18.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHScanViewController: LBXScanViewController {
    private let topOffset = 44.0
    private let leftOffset = 48.0
    
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return .lightContent
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitleColor = .white
        gk_navTitle = "扫码"
        gk_navBarAlpha = 0.0
        gk_navBackgroundColor = .clear
        gk_backImage = UIImage(named: "back_icon_white")
        setupScanStyle()
    }
    
    override func handleCodeResult(arrayResult: [LBXScanResult]) {
        //
    }
    
    deinit {
        //
    }

}

extension YHScanViewController {
    
    private func setupScanStyle() {
        var style = LBXScanViewStyle()
        style.centerUpOffset = topOffset
        style.xScanRetangleOffset = leftOffset
        style.photoframeAngleStyle = LBXScanViewPhotoframeAngleStyle.Inner
        style.photoframeLineW = 3
        style.photoframeAngleW = 18
        style.photoframeAngleH = 18
        style.isNeedShowRetangle = false
        style.anmiationStyle = LBXScanViewAnimationStyle.LineMove
        // 扫描横线图片
        style.animationImage = UIImage(named: "scan_move_line")
        // 4个角的颜色
        style.colorAngle = UIColor.white
        // 非矩形框区域颜色
        style.color_NotRecoginitonArea = UIColor.black.withAlphaComponent(0.3)
        scanStyle = style
    }
    
}
