//
//  BsBaseViewController.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/21.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit
import GKNavigationBarSwift
import IQKeyboardManagerSwift

class YHBaseViewController: UIViewController {
    override func viewDidLoad() {
        super.viewDidLoad()
        
        //背景色
        view.backgroundColor =  UIColor.pageBkgColor
        
        //vc中导航栏默认透明,需要使用到的 在各自的vc中定制
        gk_navBackgroundColor = .clear
        gk_navLineHidden = true
        gk_navBarAlpha = 0
        
        gk_backImage = UIImage(named: "nav_back_icon")
        
        
#if DEBUG
        IQKeyboardManager.shared.enable = true
#endif
//        navigationController?.interactivePopGestureRecognizer?.delegate = self
    }
    
    override var prefersStatusBarHidden: Bool {
        return self.gk_statusBarHidden
    }
    
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return self.gk_statusBarStyle
    }
    
    deinit {
#if DEBUG
        printLog(#function)
#endif
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        self.navigationController?.interactivePopGestureRecognizer?.isEnabled = true
    }
    
    func popGestureClose() {
        if let ges = self.navigationController?.interactivePopGestureRecognizer?.view?.gestureRecognizers {
            for item in ges {
                item.isEnabled = false
            }
        }
    }
    
    func popGestureOpen() {
        if let ges = self.navigationController?.interactivePopGestureRecognizer?.view?.gestureRecognizers {
            for item in ges {
                item.isEnabled = false
            }
        }
    }
    
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldRecognizeSimultaneouslyWith otherGestureRecognizer: UIGestureRecognizer) -> Bool {
        if children.count == 1 {
            return false
        }else{
            return true
        }
    }
}

//extension YHBaseViewController: UIGestureRecognizerDelegate {
////     这个方法是在手势将要激活前调用
////     返回YES允许右滑手势的激活，返回NO不允许右滑手势的激活
//    func gestureRecognizerShouldBegin(_ gestureRecognizer: UIGestureRecognizer) -> Bool {
//        return true
//    }
//}
