//
//  YHBaseViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/8.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit
import Alamofire
//import SmartCodable

class YHBaseViewModel {
    // 上传方法
    func uploadImage(_ image: UIImage, callBackBlock:@escaping (_ success: String?, _ error:YHErrorModel?)->()) {
#if DEBUG
        let size = image.imageSize()
        YHHUD.flash(message: "\(Float(size/1024/1024))M")
#endif
//        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OSS.uploadApi
//        let boundary = UUID().uuidString
//        let headers: HTTPHeaders = [
//            "Content-type": "multipart/form-data; boundary=\(boundary)",
//            "businessCode": "4001001"
//        ]
//        let _ = YHNetRequest.uplaodRequest(url: strUrl, headers: headers, image: image) { [weak self] json, code in
//            guard let _ = self else { return }
//            if json.code == 200 {
//                callBackBlock(json.data as? String, nil)
//            } else {
//                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
//                callBackBlock(nil, error)
//            }
//        } failBlock: { err in
//            callBackBlock(nil, err)
//        }
        if YHNetworkStatusManager.shared.isNetWorkOK == false {
            DispatchQueue.main.async {
                YHHUD.flash(message: "网络不可用，请检查网络设置")
                let errorModel = YHErrorModel(errorCode: 0, errorMsg: "网络不可用，请检查网络设置")
                callBackBlock(nil, errorModel)
                return
            }
            return
        }
        YHOSSManager.share.updateToken {
            YHOSSManager.share.putObject(image: image) {[weak self] success, error in
                guard let _ = self else { return }
                DispatchQueue.main.async {
                    // 在这里执行需要在主线程上完成的任务
                    callBackBlock(success, error)
                }
            }
        }
    }
    
    //换取一张
    func getPublicImageUrl(_ url: String, callBackBlock:@escaping (_ success: String?, _ error:YHErrorModel?)->()) {
//        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OSS.getPublicApi
//        let param: [String: Any] = ["fileUrl": url]
//        let _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, code in
//            //1. json字符串 转 对象
//            guard let _ = self else { return }
//            if json.code == 200 {
//                callBackBlock(json.data as? String, nil)
//            } else {
//                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
//                callBackBlock(nil, error)
//            }
//        } failBlock: { err in
//            callBackBlock(nil,err)
//        }
        if YHNetworkStatusManager.shared.isNetWorkOK == false {
            DispatchQueue.main.async {
                YHHUD.flash(message: "网络不可用，请检查网络设置")
                let errorModel = YHErrorModel(errorCode: 0, errorMsg: "网络不可用，请检查网络设置")
                callBackBlock(nil, errorModel)
                return
            }
            return
        }
        YHOSSManager.share.updateToken {
            YHOSSManager.share.getPublic(url: url, callBackBlock: { [weak self] success, error in
                guard let _ = self else { return }
                DispatchQueue.main.async {
                    // 在这里执行需要在主线程上完成的任务
                    callBackBlock(success, error)
                }
            })
        }
    }
    
    //换取多张图片
    func getPublicImageUrls(_ url: [String], callBackBlock:@escaping (_ success: [String : Any]?, _ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OSS.getPublicApi
        let param: [String: Any] = ["fileUrl": url]
        let _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(json.data as? [String : Any], nil)//使用的同学完善
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(nil, error)
            }
        } failBlock: { err in
            callBackBlock(nil,err)
        }
    }
    
    // 上传方法
    func uploadFile(_ url: String, callBackBlock:@escaping (_ success: String?, _ error:YHErrorModel?)->()) {
//        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OSS.uploadApi
//        printLog("\(url)")
//        let boundary = UUID().uuidString
//        let headers: HTTPHeaders = [
//            "Content-type": "multipart/form-data; boundary=\(boundary)",
//            "businessCode": "4001001"
//        ]
//        let _ = YHNetRequest.uplaodFileRequest(url: strUrl, headers: headers, fileUrl: url) { [weak self] json, code in
//            guard let self = self else { return }
//            if json.code == 200 {
//                callBackBlock(json.data as? String, nil)
//            } else {
//                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
//                callBackBlock(nil, error)
//            }
//        } failBlock: { err in
//            callBackBlock(nil, err)
//        }
        if YHNetworkStatusManager.shared.isNetWorkOK == false {
            DispatchQueue.main.async {
                YHHUD.flash(message: "网络不可用，请检查网络设置")
                let errorModel = YHErrorModel(errorCode: 0, errorMsg: "网络不可用，请检查网络设置")
                callBackBlock(nil, errorModel)
                return
            }
            return
        }
        YHOSSManager.share.updateToken {
            YHOSSManager.share.putFile(file: url, callBackBlock: {[weak self] success, error in
                guard let _ = self else { return }
                DispatchQueue.main.async {
                    // 在这里执行需要在主线程上完成的任务
                    callBackBlock(success, error)
                }
            })
        }
    }
}
