//
//  YHEmptyDataView.swift
//  galaxy
//
//  Created by edy on 2024/5/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

// 通用空视图
let kEmptyCommonBgName = "no_data_bg_common"
// 搜索空视图
let kEmptySearchBgName = "no_data_bg_search"
// 消息空视图
let kEmptyMessageBgName = "no_data_bg_msg"
// 订单空视图
let kEmptyOrderBgName = "no_data_bg_order"
// 无网络空视图
let kNotNetWorkBgName = "no_network_bg"


class YHEmptyDataView: UIView {

    // 组件视图总高度
    static let fixHeight = imgHeight + tipsHeight + gap
    static let imgHeight = 128.0
    static let tipsHeight = 20.0
    static let gap = 16.0
    
    var bgName: String = kEmptyCommonBgName  {
        didSet {
            emptyBgImgV.image = UIImage(named:bgName)
        }
    }
    
    var tips: String = "暂无内容" {
        didSet {
            tipsLabel.text = tips
        }
    }
    
    var topMargin: Double = 0.0 {
        didSet {
            emptyBgImgV.snp.updateConstraints { make in
                make.top.equalToSuperview().offset(topMargin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    var emptyBgImgV: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: kEmptyCommonBgName))
        return imgView
    }()
    
    var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textAlignment = .center
        label.text = "暂无内容".local
        return label
    }()
    
    static func createView(_ tips:String = "暂无内容", _ bgName:String = kEmptyCommonBgName) -> YHEmptyDataView {
        let view = YHEmptyDataView(frame:CGRect(x: 0, y: 0, width: KScreenWidth, height: self.fixHeight))
        view.bgName = bgName
        view.tips = tips
        return view
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(emptyBgImgV)
        self.addSubview(tipsLabel)
        
        emptyBgImgV.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(0)
            make.width.height.equalTo(Self.imgHeight)
            make.centerX.equalTo(self)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.top.equalTo(emptyBgImgV.snp.bottom).offset(Self.gap)
            make.height.equalTo(Self.tipsHeight)
            make.centerX.equalTo(self)
        }
    }
}
