//
//  YHHomeBannerIndicatorView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeBannerIndicatorView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var indicatorItems : Int = 0 {
        didSet {
            createUI()
        }
    }
    
    var curIndicatorIndex : Int = 0 {
        didSet {
            updateUI()
        }
    }
    
    private var arrViews : [UIView] = []
    private var normalColor : UIColor = UIColor(hex: 0xffffff, alpha: 0.3)
    private var selectedColor : UIColor = UIColor(hex: 0xffffff)
    
    lazy var subHoldView: UIView = {
        let view = UIView()
        return view
    }()
}

extension YHHomeBannerIndicatorView {
    func initView() {
        addSubview(subHoldView)
        subHoldView.snp.makeConstraints { make in
            make.centerX.centerY.equalToSuperview()
            make.top.bottom.equalToSuperview()
        }
    }
    
    func createUI() {
        arrViews.removeAll()
        subHoldView.removeSubviews()
        if indicatorItems == 1 {
            let view = UIView()
            view.backgroundColor = normalColor
            subHoldView.addSubview(view)
            view.snp.makeConstraints { make in
                make.left.equalToSuperview()
                make.right.equalToSuperview()
                make.top.bottom.equalToSuperview()
                make.width.equalTo(16)
            }
            
        } else {
            var tagView : UIView?
            for i in 0..<indicatorItems {
                let view = UIView()
                view.backgroundColor = normalColor
                subHoldView.addSubview(view)
                if i == 0 {
                    view.snp.makeConstraints { make in
                        make.left.equalToSuperview()
                        make.top.bottom.equalToSuperview()
                        make.width.equalTo(16)
                    }
                    view.backgroundColor = selectedColor
                } else if i == indicatorItems - 1 {
                    view.snp.makeConstraints { make in
                        make.left.equalTo(tagView!.snp.right).offset(3)
                        make.right.equalToSuperview()
                        make.top.bottom.equalToSuperview()
                        make.width.equalTo(16)
                    }
                } else {
                    view.snp.makeConstraints { make in
                        make.left.equalTo(tagView!.snp.right).offset(3)
                        make.top.bottom.equalToSuperview()
                        make.width.equalTo(16)
                    }
                }
                tagView = view
                arrViews.append(view)
            }
        }
    }
    
    
    func updateUI() {
        if curIndicatorIndex < indicatorItems {
            for (index,item) in arrViews.enumerated() {
                if index == curIndicatorIndex {
                    item.backgroundColor = selectedColor
                } else {
                    item.backgroundColor = normalColor
                }
            }
        }
    }
}
