//
//  YHHomeWebViewBottomForSavePicView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeWebViewBottomForSavePicView: UIView {
    static let viewH : CGFloat = 98.0
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    
    typealias Block = (Int) -> ()
    var block: Block?
    var saveButton: UIButton!
}

private extension YHHomeWebViewBottomForSavePicView {
    func setupUI() {
        backgroundColor = .white
        saveButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.contentBkgColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("保存到相册", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 0.5
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(save), for: .touchUpInside)
            return button
        }()
        addSubview(saveButton)
        saveButton.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.top.equalTo(12)
            make.height.equalTo(44)
        }
    }
    
    @objc func save() {
        block?(0)
    }
}
