//
//  YHOrderTipsView.swift
//  galaxy
//
//  Created by edy on 2024/6/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHOrderTipsView: UIView {

    static let viewH = 65.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didLookOrderBtnClicked() {
        goTabBarBy(tabType: .service)
    }
    
    func setupUI() {
        
        self.backgroundColor = UIColor(hex: 0xF8FAFB)

        let imgView = UIImageView(image: UIImage(named: "home_tips_order"))
        addSubview(imgView)
        imgView.snp.makeConstraints { make in
            make.width.height.equalTo(31)
            make.centerY.equalToSuperview()
            make.left.equalTo(14)
        }
        
        let label = UILabel()
        label.textAlignment = .left
        let aa: ASAttributedString = .init("您有", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("1", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.brandMainColor))
        let cc: ASAttributedString = .init("个服务中的优才订单", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        label.attributed.text = aa+bb+cc
        addSubview(label)
        label.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(imgView.snp.right).offset(6)
        }
        
        let btn = UIButton()
        btn.setTitle("查看进度", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandMainColor
        btn.titleLabel?.font = .PFSC_R(ofSize: 12)
        btn.addTarget(self, action: #selector(didLookOrderBtnClicked), for: .touchUpInside)
        addSubview(btn)
        btn.snp.makeConstraints { make in
            make.width.equalTo(72)
            make.height.equalTo(33)
            make.centerY.equalToSuperview()
            make.left.equalTo(label.snp.right).offset(16)
            make.right.equalTo(-16)
        }

    }
}
