//
//  YHMainCertificateEntryVC.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 我的证件 主入口页
 */

class YHMineCertificateEntryViewController: YHBaseViewController {
    
    var orderId : Int = 0
    private let certificateReqVM : YHCertificateViewModel = YHCertificateViewModel()
    
    lazy var navBar: YHCustomNavigationBar = {
        let bar = YHCustomNavigationBar.navBar()
        bar.title = "我的证件".local
        bar.showLeftSecondButtonType(.search)
        bar.backBlock = {
            [weak self] in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
        bar.leftSecondBtnClick = {
            [weak self] in
            guard let self = self else { return }
            let vc = YHCertificateSearchViewController()
            vc.orderId = orderId
            self.navigationController?.pushViewController(vc)
        }
        return bar
    }()
    
    private lazy var topBkg : UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "service_center_head_bkg3")
        imagV.contentMode = .scaleAspectFill
        return imagV
        
    }()
    
    var homeTableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = false
        tableView.rowHeight = UITableView.automaticDimension
        tableView.register(YHCertificateEntryCell.self,forCellReuseIdentifier: YHCertificateEntryCell.cellReuseIdentifier)
        return tableView
    }()
    
    let headerView : YHCertificateEntryHeadView = YHCertificateEntryHeadView()
    let bottomView : YHCertificateEntryBottomView = YHCertificateEntryBottomView()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
}

extension YHMineCertificateEntryViewController {
    func loadData() {
        if orderId != 0 {
            let param = ["order_id":orderId,"node":"1","state":"1"] as [String : Any]
            certificateReqVM.getCertificateStatisticData(params: param) { success, error in
                if success == true {
                    self.headerView.dataModel = self.certificateReqVM.certificateEntryModel
                } else {
                    YHHUD.flash(message: error?.errorMsg ?? "请求出错")
                }
                
                self.homeTableView.reloadData()
            }
        }
    }
    
    func setupUI() {
        gk_navigationBar.isHidden = true
        
        view.addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(240)
        }
        
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(YHCertificateEntryBottomView.viewH)
        }
        
        
        headerView.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: YHCertificateEntryHeadView.viewH)
        homeTableView.tableHeaderView = headerView
        
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(bottomView.snp.top)
        }
        
        // 放在最上面
        view.addSubview(navBar)
        navBar.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(k_Height_statusBar())
            make.height.equalTo(k_Height_NavContentBar)
        }
        
        homeTableView.delegate = self
        homeTableView.dataSource = self
        
        
        bottomView.block = { flag in
            if flag == 0 {
                //问题答疑
                let vc = YHQuestionAndAnswerViewController()
                self.navigationController?.pushViewController(vc)
                
            } else {
                //生成清单
                let vc = YHFileListViewController()
                vc.orderId = self.orderId
                self.navigationController?.pushViewController(vc)
            }
        }
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHMineCertificateEntryViewController : UITableViewDelegate,UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        guard let model = certificateReqVM.certificateEntryModel else { return 0 }
        return model.category_data.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kMargin
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: kMargin))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return YHCertificateEntryCell.cellH
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell0 = tableView.dequeueReusableCell(withClass: YHCertificateEntryCell.self)
        cell0.selectionStyle = .none
        
        guard let model = certificateReqVM.certificateEntryModel else { return cell0 }
        
        if indexPath.section < model.category_data.count {
            cell0.dataModel = model.category_data[indexPath.section]
        }
        return cell0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        printLog("点击了 tableView Cell \(indexPath.section)")
        
        guard let model = certificateReqVM.certificateEntryModel else { return }
        
        let vc = YHCertificateListContainerVC()
        vc.orderId = orderId
        if indexPath.section < model.category_data.count {
            vc.categoryInfo = model.category_data[indexPath.section]
        }
        self.navigationController?.pushViewController(vc)
    }
}
