//
//  YHMyDocumentsDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Alamofire

class YHMyDocumentsDetailViewModel: YHBaseViewModel {
    var mainModel: YHMyDocumentDetailModel?
    var urlModel: YHMyDocumentsUrlModel?
    var pageUrl: String?
    var personalUrl: String?
    
    //赴港计划书数据
    var arrHKPlanData : [YHHKPlanDocModel] = []
    
    
    override init() {
        super.init()
    }
    
    func requestDocumentsDetail(_ supplementId: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["supplement_id": supplementId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.detailApi
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMyDocumentDetailModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.mainModel = result
                //组装赴港计划书数据
                self.installHKPlanData()
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    
    func requestDocumentsTemporaryUrl(_ supplementId: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["supplement_id": supplementId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.temporaryUrlApi
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMyDocumentsUrlModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.urlModel = result
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestDocumentSubmit(_ supplementId: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["supplement_id": supplementId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.submitApi
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                _ = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    //提交赴港计划书
    func submitHKPlanDocument(_ params : [String : Any], callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.hkPlanApi
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                _ = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // authority 1-读 2-写
    func requestDocumentRecord(_ supplementId: String, _ authority: Int, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["supplement_id": supplementId,
                                      "authority": authority]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Documents.recordApi
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                _ = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePageURL(_ id: String, callBackBlock:@escaping (_ success: Bool?, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.pageUrl
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
//                let dic = json.data
//                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
//                    callBackBlock(false,nil)
//                    return
//                }
                self.pageUrl = json.data as? String
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalURL(callBackBlock:@escaping (_ success: Bool?, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        let _ = YHNetRequest.postRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureLook(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.look
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                _ = json.data
                self.pageUrl = json.data as? String
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureDownload(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.download
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestFileAction(_ id: String, _ type: Int, _ newArray: [String], _ oldUrl: String,callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id,
                                      "op_type": type,
                                      "new_url": newArray,
                                      "old_url": oldUrl]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.upload
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                _ = json.data
//                guard let result = YHMySignatureURLModel.deserialize(from: dic as? Dictionary) else {
//                    callBackBlock(false,nil)
//                    return
//                }
//                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignCallBack(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.callBack
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignConfirm(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.confirm
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func sendEmailForDocs(_ params : [String : Any], callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.sendMail
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else {
                callBackBlock(false, nil)
                return
            }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignBack(_ id: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.signCallBack
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestCheckPersonalStatus(_ id: String) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personal
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, code in
        } failBlock: { err in
        }
    }
}

private extension YHMyDocumentsDetailViewModel {
    func installHKPlanData() {
        guard let model = self.mainModel?.prospectus else { return }
        arrHKPlanData.removeAll()
        //1、主要事业成就
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "1、主要事业成就"
            tModel.content = model.career_achievement.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 100 {
                tModel.content = tModel.content.slicing(from: 0, length: 100) ?? ""
            }
            tModel.type = .planDocQuestion1
            tModel.isFirstData = true
            arrHKPlanData.append(tModel)
        }
        
        //2、专业技能成就
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "2、专业技能成就"
            tModel.content = model.professional_skills.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 100 {
                tModel.content = tModel.content.slicing(from: 0, length: 100) ?? ""
            }
            tModel.type = .planDocQuestion2
            
            arrHKPlanData.append(tModel)
        }
        
        //3、学业成就
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "3、学业成就"
            tModel.content = model.academic_achievement.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 100 {
                tModel.content = tModel.content.slicing(from: 0, length: 100) ?? ""
            }
            tModel.type = .planDocQuestion3
            
            arrHKPlanData.append(tModel)
        }
        
        //4、未来发展计划
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "4、未来发展计划"
            tModel.content = model.plan_detail.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 100 {
                tModel.content = tModel.content.slicing(from: 0, length: 100) ?? ""
            }
            tModel.type = .planDocQuestion4
            
            arrHKPlanData.append(tModel)
        }
        
        //5、专业资格及奖项
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "5、专业资格及奖项"
            tModel.content = model.qualifications_and_awards.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 100 {
                tModel.content = tModel.content.slicing(from: 0, length: 100) ?? ""
            }
            tModel.type = .planDocQuestion5
            
            arrHKPlanData.append(tModel)
        }
        
        //6、其他材料
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "6、其他材料"
            tModel.content = model.other.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 100 {
                tModel.content = tModel.content.slicing(from: 0, length: 100) ?? ""
            }
            tModel.type = .planDocQuestion6
            
            arrHKPlanData.append(tModel)
        }
        //6、备注
        do {
            let tModel = YHHKPlanDocModel()
            tModel.title = "7、备注"
            tModel.content = model.remark.defaultStringIfEmpty(detaultValue: "")
            if tModel.content.count > 500 {
                tModel.content = tModel.content.slicing(from: 0, length: 500) ?? ""
            }
            tModel.type = .planOther
            tModel.isLastData = true
            
            arrHKPlanData.append(tModel)
        }
    }
}
