//
//  YHScorePersonInfoCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHScorePersonInfoCell: UITableViewCell {
    static let cellReuseIdentifier = "YHScorePersonInfoCell"
    
    
    lazy var requestVM : YHBaseViewModel =  {
        let r = YHBaseViewModel()
        return r
    }()
    
    var dataModel : YHScoreResultModel? {
        didSet {
            updateUI()
        }
    }
    
    //头像
    private lazy var headImagV : UIImageView = {
        let imageV = UIImageView(image: UIImage(named: "mine_head_default"))
        imageV.contentMode = .scaleAspectFill
        imageV.layer.cornerRadius = 20.5
        imageV.clipsToBounds = true
        return imageV
    }()
    
    //姓名
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 16)
        return lable0
    }()
    
    //电话号码
    private lazy var phoneLable : UILabel = {
        let lable0 = UILabel(text: "")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 12)
        return lable0
    }()
    
    
    //综合得分
    private lazy var scoreLable : UILabel = {
        let lable0 = UILabel(text: "0")
        lable0.textColor = UIColor(hex: 0xFFEEB0)
        lable0.font = UIFont(name: "DINAlternate-Bold", size: 68)
        lable0.textAlignment = .center
        return lable0
    }()
    
    
    //分
    private lazy var fenLable : UILabel = {
        let lable0 = UILabel(text: "分")
        lable0.textColor = UIColor.white
        lable0.font =  UIFont.PFSC_R(ofSize: 16)
        lable0.textAlignment = .center
        return lable0
    }()
    
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    private let secondHoldView = UIView()
    private let fakeView = UIView()
    
    
    var gradientLayer: CAGradientLayer = {
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [UIColor(hex: 0xFFF9E3, alpha: 1.0).cgColor, UIColor(hex: 0xFFE895, alpha: 1.0).cgColor]
        gradientLayer.startPoint = CGPoint(x: 0.5, y: 0)
        gradientLayer.endPoint = CGPoint(x: 0.5, y: 1)
        gradientLayer.locations = [NSNumber(value: 0.2)]
        gradientLayer.frame = CGRect(x: 0, y: 0, width: 200, height: 60)
        return gradientLayer
    }()
}

extension YHScorePersonInfoCell {
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        let lable0 = UILabel(text: "香港优才评分报告")
        lable0.textColor = .white
        lable0.font = UIFont.PFSC_B(ofSize: 26)
        contentView.addSubview(lable0)
        lable0.snp.makeConstraints { make in
            make.top.equalTo(26.5)
            make.left.equalTo(7)
            make.right.equalTo(7)
            make.height.equalTo(36.5)
        }
        
        
        let lable1 = UILabel(text: "根据您填写的资料情况生成")
        lable1.textColor = UIColor(hex: 0xffffff,alpha: 0.8)
        lable1.font = UIFont.PFSC_R(ofSize: 13)
        contentView.addSubview(lable1)
        lable1.snp.makeConstraints { make in
            make.top.equalTo(lable0.snp.bottom).offset(6)
            make.left.equalTo(25)
            make.right.equalTo(lable0.snp.right)
            make.height.equalTo(18)
        }
        
        let iconImagV = UIImageView(image: UIImage(named: "score_icon_0"))
        iconImagV.contentMode = .scaleAspectFill
        contentView.addSubview(iconImagV)
        iconImagV.snp.makeConstraints { make in
            make.centerY.equalTo(lable1)
            make.left.equalTo(lable0.snp.left)
            make.width.equalTo(10)
            make.height.equalTo(12)
        }
        
        
        
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.equalTo(lable1.snp.bottom).offset(28.5)
            make.left.right.equalToSuperview()
            make.height.equalTo(74)
            make.bottom.equalToSuperview().offset(-14)
        }
        let holdViewBkgV = UIImageView(image: UIImage(named: "score_icon_bkg1"))
        holdViewBkgV.contentMode = .scaleAspectFill
        holdView.addSubview(holdViewBkgV)
        holdViewBkgV.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        
        let bkgImageV = UIImageView(image: UIImage(named: "score_icon_bkg"))
        bkgImageV.contentMode = .scaleAspectFill
        holdView.addSubview(bkgImageV)
        bkgImageV.snp.makeConstraints { make in
            make.top.equalTo(15)
            make.right.equalTo(-31.5)
            make.width.equalTo(68)
            make.height.equalTo(74)
        }
        
        
        // 头像 名称  电话号码  得分
        holdView.addSubview(headImagV)
        headImagV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(18)
            make.width.height.equalTo(41)
        }
        
        
        holdView.addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.top.equalTo(headImagV.snp.top)
            make.left.equalTo(headImagV.snp.right).offset(15)
            make.height.equalTo(23)
            make.right.equalToSuperview().offset(-kMargin)
        }
        
        
        holdView.addSubview(phoneLable)
        phoneLable.snp.makeConstraints { make in
            make.top.equalTo(nameLable.snp.bottom)
            make.left.equalTo(nameLable.snp.left)
            make.height.equalTo(20)
            make.width.equalTo(200)
        }
        
        contentView.addSubview(secondHoldView)
        secondHoldView.snp.makeConstraints { make in
            make.bottom.equalTo(holdView.snp.top)
            make.right.equalTo(holdView.snp.right).offset(5)
            make.height.equalTo(105)
            make.width.equalTo(148)
        }
        
        let imageV = UIImageView(image: UIImage(named: "score_maisui_icon"))
        imageV.contentMode = .scaleAspectFill
        secondHoldView.addSubview(imageV)
        imageV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        let width  = scoreLable.requiredWidth
        
        fakeView.frame = CGRect(x: (148 - width)/2.0, y: (105 - 80)/2.0, width: width, height: 80)
        secondHoldView.addSubview(fakeView)
        
        gradientLayer.frame = fakeView.bounds
        
        scoreLable.layer.frame = gradientLayer.bounds
        gradientLayer.mask = scoreLable.layer
        
        
        fakeView.layer.insertSublayer(gradientLayer, at: 0)
        
        
        secondHoldView.addSubview(fenLable)
        fenLable.frame = CGRect(x: fakeView.frame.origin.x + width, y: fakeView.frame.origin.y + 80 - 13 - 17 - 4, width: 18, height: 17)
    }
    
    
    private func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        handleCardImage()
        nameLable.text = model.userinfo?.username ?? "-"
        phoneLable.text = model.userinfo?.mobile ?? "-"
        
        let score : String = String(model.total_score?.sum_score ?? 0)
        scoreLable.text = score
        let width  = scoreLable.requiredWidth
        
        fakeView.frame = CGRect(x: (148 - width)/2.0, y: (105 - 80)/2.0, width: width, height: 80)
        gradientLayer.frame = fakeView.bounds
        scoreLable.layer.frame = gradientLayer.bounds
        gradientLayer.mask = scoreLable.layer
        fakeView.layer.insertSublayer(gradientLayer, at: 0)
        
//        secondHoldView.backgroundColor = .red//for test hjl
        
        
        fenLable.frame = CGRect(x: fakeView.frame.origin.x + width, y: fakeView.frame.origin.y + 80 - 13 - 17 - 4, width: 18, height: 17)
    }
    
    
    
    private func handleCardImage() {
//        guard let dataModel = dataModel?.userinfo, dataModel.head_url.isEmpty == false else { return }
//        
//        let url = dataModel.head_url
//        if url.isEmpty == false {
//            self.requestVM.getPublicImageUrl(url) {[weak self] success, error in
//                guard let self = self else { return }
//                guard success != nil else { return }
//                self.headImagV.kf.setImage(with: URL(string: success), placeholder: UIImage(named: "global_default_image"))
//            }
//        }
    }
}
