//
//  YHScoreResultView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHScoreResultView: UIView {
    
    
    var dataModel : YHScoreResultBaseModel? {
        didSet {
            updateUI()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        setupUI()
    }
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    
    //固定高度
    static let viewH : CGFloat = 60.5
    
    
    //icon
    private lazy var iconImageV : UIImageView = {
        let imageV = UIImageView(image: UIImage(named: "score_satisfy_0"))
        imageV.contentMode = .scaleAspectFit
        return imageV
    }()
    
    
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "年龄：32")
        lable0.textColor = UIColor(hex: 0x4E4E4E)
        lable0.font = UIFont.PFSC_M(ofSize: 14)
        return lable0
    }()
    
    
    private lazy var desLable : UILabel = {
        let lable0 = UILabel(text: "得分：30分")
        lable0.textColor = UIColor(hex: 0x4E4E4E)
        lable0.font = UIFont.PFSC_M(ofSize: 14)
        return lable0
    }()
    
    
    private lazy var bottomLine : UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex:0xF0F0F0)
        return view
    }()
}

private extension YHScoreResultView {
    func setupUI() {
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        let holdView = UIView()
        holdView.backgroundColor = UIColor.contentBkgColor
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.bottom.equalTo(bottomLine.snp.top).offset(-kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        
        
        holdView.addSubview(iconImageV)
        iconImageV.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(14)
        }
        
        holdView.addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(iconImageV.snp.right).offset(8)
        }
        
        let line = UIView()
        line.backgroundColor = UIColor.labelTextColor2
        holdView.addSubview(line)
        line.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(nameLable.snp.right).offset(20)
            make.height.equalTo(13.5)
            make.width.equalTo(0.5)
        }
        
        holdView.addSubview(desLable)
        desLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(line.snp.right).offset(20)
        }
    }
    
    private func updateUI() {
        guard let model = dataModel else { return }
        
        if model.answer.isEmpty {
            if model.result.contains("年龄") {
                iconImageV.image = UIImage(named: "score_satisfy_0")
                nameLable.text = model.result
            } else {
                iconImageV.image = UIImage(named: "score_satisfy_1")
                nameLable.text = "不满足"
            }
        } else {
            iconImageV.image = UIImage(named: "score_satisfy_0")
            nameLable.text = model.result
        }
        
        let score = "得分：" + String(model.score) + "分"
        desLable.text = score
    }
}
