//
//  YHFamilyInitialInfo.swift
//  galaxy
//
//  Created by edy on 2024/1/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

protocol YHFormItemProtocol {
    
    func getTitle() -> String
    func getSubTitle() -> String
}

// 表单标题类型
enum YHFormTitleItemType:Int, CaseIterable {
    
    // 配偶
    case sponse = 1
    // 父母
    case parent
    // 子女
    case child
    // 兄弟姐妹
    case brother
    
    // 随行
    case accompany
    // 国籍
    case nationality
    // 居住信息
    case liveInfo
    // 港澳通信证
    case hkAndMacaoPassport
    
    // 中国身份证
    case chinaIdCardInfo
    // 护照及其他旅行证件
    case passPortOrTravelInfo
    
    // 配偶信息
    case spouseInfo
    // 职业信息
    case occupationInfo
    // 学历学位信息
    case degreeInfo
    // 在港信息
    case inHongKongInfo
    // 香港身份证
    case hkIdentityCardInfo
    
    // 父亲信息
    case fatherInfo
    // 母亲信息
    case motherInfo
    // 基本信息
    case basicInfo
    // 子女信息
    case childInfo
    // 是否前次婚姻子女
    case isPreviousMarriageChild
    // 兄弟姐妹信息
    case brotherInfo
    // 主申请人学历
    case mainApplicantEducation
    // 主申请人专业资格及会员资格
    case mainApplicantProfessionalQualification
    // 学历证书姓名及出生日期正确性
    case edutionalCertificateNameAndBirthday


    
}

// 表单添加条目类型
enum YHFormAddItemType:Int {
    
    case addChild = 1
    case addBrother
    case addDegree
    case addEducation
    case addCertificateInfo
}

// 表单具体条目类型
enum YHFormDetailItemType:Int {
    
    // 是否随行至香港
    case isAccompanyToHK =  1
    // 是否与主申请人同住
    case isLiveTother
    // 国家/地区
    case nationOrArea
    // 现居住城市
    case liveCity
    // 详细地址
    case detailAddress
    // 是否在海外居住满1年及以上
    case isLiveOverSeasMore1Year
    // 是否办理
    case isHandleHKPassPort
    
    // 证件类别
    case certificateType
    // 证件号码
    case certificateNumber
    // 中国身份证号
    case chinaIdentityCardNumber
    // 旅行证件号码
    case traverlPassportNumber
    // 签发日期
    case certificateSignDate
    // 届满日期
    case certificateValidDate
    // 签发地
    case certificateSignPlace
    
    // 配偶姓名
    case spouseName
    // 曾用名
    case everName
    // 婚前姓氏
    case befourMarryFirstName
    // 出生日期
    case birthday
    // 出生国家/地区
    case birthNation
    // 出生城市
    case birthCity
    // 职业
    case occupation
    // 职业名称
    case occupationName
    // 是否拥有学位
    case ownDegree
    // 目前是否在港
    case isNowInHK
    // 获准逗留至
    case stayHKDate
    // 在港身份
    case roleInHK
    // 是否办理过(香港身份证)
    case isHaveHkIdentityCard
    // 香港身份证号码
    case hkIdentityCardNumber
    // 学位信息X
    case degreeDetailInfo
    
    // 父亲姓名
    case fatherName
    // 母亲姓名
    case motherName
    // 婚姻状况
    case marriageState
    // 现居住国家/地区
    case liveNationOrArea
    // 仅有两个按钮 标题数组有外部提供
    case onlyDoubleChoice
    // 主申请人和现配偶是否拥有孩子抚养权
    case ownCustody
    // 子女姓名
    case childName
    // 性别
    case gender
    // 是否为前次婚姻子女
    case isPreviousMarriageChild
    // 兄弟姐妹姓名
    case brotherName
    
    // 学历信息相关
    case educationInfo
    // 学校全称
    case universityFullName
    // 授课形式
    case educationStyle
    // 入学年月
    case educationTime
    // 毕业年月
    case graduateTime
    // 专业
    case educationMajor
    // 学位
    case educationDegree
    // 学位类型
    case degreeType
    // 上课国家/地区
    case educationCountry
    // 上课城市
    case educationCity
    
    // 证书信息
    case certificateInfo
    // 资格证书名称
    case qualificationCertificateName
    // 颁授机构全称
    case conferAgencyFullName
    // 颁授年份
    case conferTime
    // 颁授国家/地区
    case conferCountry
    // 颁授城市
    case conferCity
}

//添加item
class YHFormAddItem : YHFormItemProtocol
{
    var type: YHFormAddItemType
    
    init(type: YHFormAddItemType) {
        self.type = type
    }
    
    func getTitle() -> String {
        switch self.type {
        case .addChild:
            return "新增子女".local
        case .addBrother:
            return "新增兄弟姐妹".local
        case .addDegree:
            return "增加学位信息".local
        case .addEducation:
            return "新增学历信息".local
        case .addCertificateInfo:
            return "新增证书信息".local
        }
    }
    
    func getSubTitle() -> String {
        return ""
    }
}


// 标题item
class YHFormTitleItem : YHFormItemProtocol {
    
    var type: YHFormTitleItemType
    
    init(type: YHFormTitleItemType) {
        self.type = type
    }
    
    func getTitle() -> String {
        switch self.type {
        case .sponse:
            return "配偶".local
        case .parent:
            return "父母".local
        case .brother:
            return "兄弟姐妹".local
        case .child:
            return "子女".local
        case .accompany:
            return "随行".local
        case .nationality:
            return "国籍".local
        case .liveInfo:
            return "居住信息".local
        case .hkAndMacaoPassport:
            return "港澳通行证".local
        case .chinaIdCardInfo:
            return "中国身份证".local
        case .passPortOrTravelInfo:
            return "护照及其他旅行证件".local
        case .spouseInfo:
            return "配偶信息".local
        case .occupationInfo:
            return "职业信息".local
        case .degreeInfo:
            return "学历学位信息".local
        case .inHongKongInfo:
            return "在港信息".local
        case .hkIdentityCardInfo:
            return "香港身份证".local
        case .fatherInfo:
            return "父亲信息".local
        case .motherInfo:
            return "母亲信息".local
        case .basicInfo:
            return "基本信息".local
        case .childInfo:
            return "子女信息".local
        case .isPreviousMarriageChild:
            return "是否前次婚姻子女".local
        case .brotherInfo:
            return "兄弟姐妹信息".local
        case .mainApplicantEducation:
            return "主申请人学历".local
        case .mainApplicantProfessionalQualification:
            return "主申请人专业资格及会员资格".local
        case .edutionalCertificateNameAndBirthday:
            return "学历证书姓名及出生日期正确性".local
            
        }
    }
    
    func getSubTitle() -> String {
        switch self.type {
        case .sponse:
            return "".local
        case .parent:
            return String(format: " (%@)", "包含已故".local)
        case .brother:
            return String(format: " (%@)", "如无可不填".local)
        case .child:
            return String(format: " (%@)", "如无可不填".local)
        case .mainApplicantEducation:
            return "（请从大专开始写起）".local
        case .mainApplicantProfessionalQualification:
            return "(如有，非必填）".local
        case .edutionalCertificateNameAndBirthday:
            return "".local
        case .isPreviousMarriageChild:
            return "".local
        case .accompany:
            return "".local
        case .nationality:
            return "".local
        case .liveInfo:
            return "".local
        case .hkAndMacaoPassport:
            return "".local
        case .chinaIdCardInfo:
            return "".local
        case .passPortOrTravelInfo:
            return "".local
        case .spouseInfo:
            return "".local
        case .occupationInfo:
            return "".local
        case .degreeInfo:
            return "".local
        case .inHongKongInfo:
            return "".local
        case .hkIdentityCardInfo:
            return "".local
        case .fatherInfo:
            return "".local
        case .motherInfo:
            return "".local
        case .basicInfo:
            return "".local
        case .childInfo:
            return "".local
        case .brotherInfo:
            return "".local
            
            
        }
    }
}

class YHFormDegreeItem:SmartCodable {
    
    
    var title:String?
    var subTitle1:String? {
        return "学位证".local
    }
    var subTitle2:String? {
        return "颁发地区".local
    }
    var value1:String?
    var value2:String?
    
    init(title: String? = nil, value1: String? = nil, value2: String? = nil) {
        self.title = title
        self.value1 = value1
        self.value2 = value2
    }
    
    required init() {
        
    }
}

// 具体item
class YHFormDetailItem : YHFormItemProtocol {
    
    var type: YHFormDetailItemType
    // 是否是必填项
    var isNeed: Bool = true
    
    var value: String?
    // 灰色提示
    var placeHolder: String?
    // 红色提示文字
    var tips:String?
    
    // 是否需要展示Tips
    var isShowTips:Bool {
        if let value = value, !value.isEmpty {
            return false
        }
        return true
    }
    
    init(type: YHFormDetailItemType, isNeed:Bool = true, value:String? = "", placeHolder:String? = "", tips:String? = "") {
        self.type = type
        self.isNeed = isNeed
        self.value = value
        self.placeHolder = placeHolder
        self.tips = tips
    }
    
    
    func getTitle() -> String {
        
        switch type {
        case .isAccompanyToHK:
            return "是否随行至香港".local
        case .isLiveTother:
            return "是否与主申请人同住".local
        case .nationOrArea:
            return String(format: "%@/%@", "国家".local, "地区".local)
        case .liveCity:
            return "现居住城市".local
        case .detailAddress:
            return "详细地址".local
        case .isLiveOverSeasMore1Year:
            return "是否在海外居住满1年及以上".local
        case .isHandleHKPassPort:
            return "是否办理".local
        case .certificateType:
            return "证件类别".local
        case .certificateNumber:
            return "证件号码".local
        case .chinaIdentityCardNumber:
            return "中国身份证号".local
        case .traverlPassportNumber:
            return "证件号码".local
        case .certificateSignDate:
            return "签发日期".local
        case .certificateValidDate:
            return "届满日期".local
        case .certificateSignPlace:
            return "签发地".local
        case .spouseName:
            return "配偶姓名".local
        case .everName:
            return "曾用名".local
        case .befourMarryFirstName:
            return "婚前姓氏".local
        case .birthday:
            return "出生日期".local
        case .birthNation:
            return "出生国家/地区".local
        case .birthCity:
            return "出生城市".local
        case .occupation:
            return "职业".local
        case .occupationName:
            return "职业名称".local
        case .ownDegree:
            return "是否拥有学位".local
        case .isNowInHK:
            return "目前是否在港".local
        case .stayHKDate:
            return "获准逗留至".local
        case .roleInHK:
            return "在港身份".local
        case .isHaveHkIdentityCard:
            return "是否办理过".local
        case .hkIdentityCardNumber:
            return "香港身份证号码".local
        case .degreeDetailInfo:
            return "学位信息X".local
        case .fatherName:
            return "父亲姓名".local
        case .motherName:
            return "母亲姓名".local
        case .marriageState:
            return "婚姻状况".local
        case .liveNationOrArea:
            return "现居住国家/地区".local
        case .ownCustody:
            return "主申请人和现配偶是否拥有孩子抚养权".local
        case .childName:
            return "子女姓名".local
        case .gender:
            return "性别".local
        case .isPreviousMarriageChild:
            return "是否前次婚姻子女".local
        case .brotherName:
            return "兄弟姐妹姓名".local
        case .onlyDoubleChoice:
            return "".local
            
        case .educationInfo:
            return "".local
        case .certificateInfo:
            return "".local
        case .universityFullName:
            return "学校全称".local
        case .educationStyle:
            return "授课形式".local
        case .educationTime:
            return "入学年月".local
        case .graduateTime:
            return "毕业年月".local
        case .educationMajor:
            return "专业".local
        case .educationDegree:
            return "学位".local
        case .degreeType:
            return "学位类型".local
        case .educationCountry:
            return "上课国家/地区".local
        case .educationCity:
            return "上课城市".local
            
        case .qualificationCertificateName:
            return "资格证书名称".local
        case .conferAgencyFullName:
            return "颁授机构全称".local
        case .conferTime:
            return "颁授年份".local
        case .conferCountry:
            return "颁授国家/地区".local
        case .conferCity:
            return "颁授城市".local
        }

    }
    
    func getSubTitle() -> String {
        return ""
    }
}

/*  ***** ***** ***** ***** ***** ***** ***** ***** */

// MARK: - 家庭成员 YHData
class YHFamilyMemberGroupInfo: SmartCodable {
    
    var father: YHFamilyMember?
    var mother: YHFamilyMember?
    var spouse: YHFamilyMember?
    var child: [YHFamilyMember]?
    var brother: [YHFamilyMember]?

    enum CodingKeys: String, CodingKey {
        case father = "father"
        case mother = "mother"
        case spouse = "spouse"
        case brother = "brother"
        case child = "child"
    }
    
    func checkDefaultValue() -> Self {
        _ = father?.checkDefaultValue()
        _ = mother?.checkDefaultValue()
        _ = spouse?.checkDefaultValue()
        
        if let child = child {
            for item in child {
                _ = item.checkDefaultValue()
            }
        }
        if let brother = brother {
            for item in brother {
                _ = item.checkDefaultValue()
            }
        }
        return self
    }
    required init() {
        
    }
}

enum YHFamilyMemberType: Int {
    // 与后台relation字段一致
    // 1父亲  2母亲 3配偶 4子女 5兄弟姐妹
    case none = 0
    case father = 1
    case mother = 2
    case spouse = 3
    case child = 4
    case brother = 5
}



class YHFamilyMember: SmartCodable, YHFormItemProtocol {
    
    var detailId: Int = 0
    var nationality: String = ""
    var orderId: Int = 0
    var relation: String = ""
    var hasDegree: String = ""
    var hasDegreeJson: [YHHasDegreeJson] = []
    var statement: Int = 0
    var subsetName: String = ""
    var subsetNamePinyin: YHSubsetNamePinyin = YHSubsetNamePinyin()
    var birthday: String = ""
    var birthPlace: YHAddress = YHAddress()
    var occupation: String = ""
    var occupationName: String = ""
    var operatorName: String = ""
    var hkIdentityCard: String?
    var married: String = ""
    var address: YHAddress = YHAddress()
    var hkIdentity: String = ""
    var liveCountry: String = ""
    var finishFollow: Int = 0
    var step: Int = 0
    var certificates: YHCertificates = YHCertificates()
    var usedName: String = ""
    var hkIdentityOther: String = ""
    var isHkHandled: Int = 0
    var isInHk: Int = 0
    var surname: String = ""
    
    // 是否办理过香港身份证
    var childHasHkId: YHChildStepchildClass = YHChildStepchildClass()
    // 是否前一次婚姻子女
    var childStepchild: YHChildStepchildClass = YHChildStepchildClass()
    // 目前是否在港
    var childInHk: YHChildStepchildClass = YHChildStepchildClass(has:"N")
    var countryIdentity: YHChildStepchildClass = YHChildStepchildClass()
    
    // 是否已故 1:是 0：否
    var deceased: Int = 0
    // 主申请人和现配偶是否拥有孩子抚养权 1:是 0：否
    var custody: Int = 0
    // 是否出生国外 1:是 0：否
    var birthPlaceAboard: Int = 0
    // 是否与主申请人同住 1：是 0：否
    var nows: Int = 0
    // 是否要办理港澳通行证 1：是 0：否
    var isHandled: Int = 0
    // notFillNumber = -1 表示还没开始填写任意数据项
    var notFillNumber: Int = -1
    
    // 是否随行 1：是 2：否
    var follow: Int = 1
    // 是否在海外居住满1年及以上 1:是 2：否
    var isLiveOverseaYear: Int = 2
    // 性别 1:男 2：女
    var sex: Int = 1
    
    func checkDefaultValue() -> Self {
        
//        if hasDegree.isEmpty { // 默认无学位
//            hasDegree = "0"
//        }
        if childHasHkId.has.isEmpty { // 默认未办理过香港身份证
            childHasHkId.has = "N"
        }
        if childStepchild.has.isEmpty { // 默认不是前一次婚姻子女
            childStepchild.has = "N"
        }
        if childInHk.has.isEmpty { // // 默认目前不在香港港
            childInHk.has = "N"
        }
        
        if follow != 1 && follow != 2 { // 默认随行
            if self.relationType == .father || self.relationType == .mother || self.relationType == .brother {
                follow = 0
            } else {
                follow = 1
            }
        }
        
        if isLiveOverseaYear != 1 && isLiveOverseaYear != 2 { // 默认在海外未居住满一年以上
            isLiveOverseaYear = 2
        }
        
        
    
        return self
    }

    enum CodingKeys: String, CodingKey {
        case detailId = "id"
        case deceased = "deceased"
        case custody = "custody"
        case nationality = "nationality"
        case orderId = "order_id"
        case relation = "relation"
        case hasDegree = "has_degree"
        case hasDegreeJson = "has_degree_json"
        case follow = "follow"
        case statement = "statement"
        case subsetName = "subset_name"
        case subsetNamePinyin = "subset_name_pinyin"
        case birthday = "birthday"
        case birthPlaceAboard = "birth_place_aboard"
        case birthPlace = "birth_place"
        case occupation = "occupation"
        case occupationName = "occupation_name"
        case operatorName = "operator_name"
        case childHasHkId = "child_has_Hk_id"
        case hkIdentityCard = "hk_identity_card"
        case sex = "sex"
        case married = "married"
        case nows = "nows"
        case address = "address"
        case childStepchild = "child_stepchild"
        case childInHk = "child_in_hk"
        case countryIdentity = "country_identity"
        case hkIdentity = "hk_identity"
        case liveCountry = "live_country"
        case finishFollow = "finish_follow"
        case step = "step"
        case isHandled = "is_handled"
        case notFillNumber = "not_fill_number"
        case certificates = "certificates"
        case usedName = "used_name"
        case hkIdentityOther = "hk_identity_other"
        case isHkHandled = "is_hk_handled"
        case isInHk = "is_in_hk"
        case isLiveOverseaYear = "is_live_oversea_year"
        case surname = "surname"
    }
            
    required init() {
        
    }
    
    // 国籍是否是中国
    func isChinese() -> Bool {
        return nationality == "中国-China"
    }
    
    // 是否随行
    func isFollow() -> Bool {
        return follow == 1
    }
    
    func setFollow(_ value:Bool) {
        self.follow = (value ? 1 : 2)
    }
    
    // 是否要办理港澳通行证
    func isNeedHandleHKPassPort() -> Bool {
        return  self.isHandled == 1
    }
    
    func setNeedHandleHKPassPort(_ value:Bool) {
        self.isHandled = (value ? 1 : 0)
    }
    
    // 是否与主申请人同住
    func isLiveTother() -> Bool {
        return self.nows == 1
    }
    
    func setLiveTother(_ value:Bool) {
        self.nows = (value ? 1 : 0)
    }
    
    // 是否在海外居住满1年及以上
    func isOverSeasOver1Year() -> Bool {
        return self.isLiveOverseaYear == 1
    }
    
    func setOverSearsOver1Year(_ value:Bool) {
        self.isLiveOverseaYear = value ? 1 : 2
    }
    
    // 是否出生国外
    func isBirthOverSeas() -> Bool {
        return self.birthPlaceAboard == 1
    }
    
    func setBirthOverSeas(_ value:Bool) {
        return self.birthPlaceAboard = value ? 1 : 0
    }
    
    // 目前是否在港
    func isNowInHK() -> Bool {
        if self.childInHk.has == "Y" {
            return true
        } else if self.childInHk.has == "N" {
            return false
        }
        return false
    }
    
    func setNowIsInHK(_ value:Bool) {
        self.childInHk.has = value ?  "Y" : "N"
    }
    
    // 是否办理过香港身份证
    func isHaveHKIdentityCard() -> Bool {
        if self.childHasHkId.has == "Y" {
            return true
        } else if self.childHasHkId.has == "N" {
            return false
        }
        return false
    }
    
    func setHaveHKIdentityCard(_ value:Bool) {
        self.childHasHkId.has = value ?  "Y" : "N"
    }
    
    // 是否拥有学位
    func hasDegreeName() -> String {
        if hasDegree == "1" {
            return "有学位".local
        } else if hasDegree == "0" {
            return "无学位".local
        }
        return ""
    }
    
    func isHaveDegree() ->Bool {
        return self.hasDegree == "1"
    }
    
    func setHaveDegree(_ val:Bool) {
        self.hasDegree = val ? "1" : "0"
    }
    
    // 是否已故
    func isDead() -> Bool {
        return self.deceased == 1
    }
    
    func setIsDead(_ val:Bool) {
        self.deceased = (val ? 1 : 0)
    }
    
    // 是否在职
    func isNowHaveJob() -> Bool {
        return self.occupation == "在职"
    }
    
    // 主申请人和现配偶是否拥有孩子抚养权
    func isOwnCustody() -> Bool {
        return self.custody == 1
    }
    
    func setOwnCustody(_ val:Bool) {
        self.custody = val ? 1 : 0
    }
    
    // 是否是男性
    func isMale() -> Bool {
      return  self.sex == 1
    }
    
    func setMale(_ val: Bool) {
        self.sex = (val ? 1 : 2)
    }
    
    func sexName() -> String? {
        if self.sex == 1 {
            return "男".local
        } else if self.sex == 2 {
            return "女".local
        }
        return ""
    }
    
    func setSexName(_ sexName:String?) {
        guard let sexName = sexName else { return }
        if sexName == "男".local {
            self.sex = 1
        } else if sexName == "女".local {
            self.sex = 2
        }
    }
    
    // 是否前一次婚姻子女
    func isPreviousMarriageChild() -> Bool {
       return self.childStepchild.has == "Y"
    }
    
    func setPreviousMarriageChild(_ val: Bool) {
        self.childStepchild.has = (val ? "Y" : "N")
    }
    
    // 是否住在中国
    func isLiveInChina() ->Bool {
        // 默认在中国
        if isEmptyString(self.address.country) { return true }
        if self.address.country.contains("中国") {
            return true
        }
        return false
    }
    
    // 根据生日推算年龄
    func getAge(birthday:String) ->Int {
        let arr = birthday.components(separatedBy: YHDatePickView.separator)
        if arr.count == 3 {
            let year = Int(arr[0]) ?? 0
            let month = Int(arr[1]) ?? 0
            let day = Int(arr[2]) ?? 0
            
            let now = Date()
            let formatter = DateFormatter()
            formatter.dateFormat = "yyyy-MM-dd"
            let current = formatter.string(from: now)
            let curArr = current.components(separatedBy:"-")
            if curArr.count == 3 {
                let cyear = Int(curArr[0]) ?? 0
                let cmonth = Int(curArr[1]) ?? 0
                let cday = Int(curArr[2]) ?? 0
                
                var age = cyear - year
                if cmonth < month {
                    age -= 1
                } else if cmonth == month && cday < day {
                    age -= 1
                }
                return age
            }
        }
        return 0
    }
    
    func is18YearsOld() -> Bool {
       let age = getAge(birthday: birthday)
       return age >= 18
    }
    
    var relationType:YHFamilyMemberType {
        
        get {
            if relation == "1" {
                return .father
            } else if relation == "2" {
                return .mother
            } else if relation == "3" {
                return .spouse
            } else if relation == "4" {
                return .child
            } else if relation == "5" {
                return .brother
            }
            
            return .none
        }
        
        set {
            if newValue == .father {
                relation = "1"
            } else if newValue == .mother {
                relation = "2"
            } else if newValue == .spouse {
                relation = "3"
            } else if newValue == .child {
                relation = "4"
            } else if newValue == .brother {
                relation = "5"
            } else {
                relation = ""
            }
        }
    }
    
    // YHFamilyMemberProtocol
    func getTitle() -> String {
        // 1父亲  2 母亲 3 配偶 4子女 5兄弟姐妹
        if relation == "1" {
            return "父亲".local
        } else if relation == "2" {
            return "母亲".local
        } else if relation == "3" {
            return "配偶".local
        } else if relation == "4" {
            return "子女".local
        } else if relation == "5" {
            return "兄弟姐妹".local
        }
        
        return ""
    }
    
    func getSubTitle() -> String {
        return ""
    }
}

// MARK: - 居住地址信息 YHAddress
class YHAddress: SmartCodable {
    
    var area: [String] = []
    var country: String = ""
    var details: String = ""
    var foreign: String = ""

    enum CodingKeys: String, CodingKey {
        case area = "area"
        case country = "country"
        case details = "details"
        case foreign = "foreign"
    }

    required init() {
        
    }
    
    // 清空地址信息
    func clearAddress() {
        self.area = []
        self.country = ""
        self.details = ""
        self.foreign = ""
    }
}

// MARK: - YHChildStepchildClass
class YHChildStepchildClass: SmartCodable {
    var has: String = ""
    var info: String = ""
    var year: String = ""
    var month: String = ""
    // 龙哥所加字段
    var number:String = ""

    enum CodingKeys: String, CodingKey {
        case has = "has"
        case info = "info"
        case year = "year"
        case month = "month"
        case number = "number"
    }

    required init() {
        
    }
    
    init(has:String = "", info:String = "", year:String = "", month:String = "") {
        self.has = has
        self.info = info
        self.year = year
        self.month = month
    }
}

// MARK: - YHSubsetNamePinyin
class YHSubsetNamePinyin: SmartCodable {
    var familyName: String = ""
    var givenName: String = ""

    enum CodingKeys: String, CodingKey {
        case familyName = "family_name"
        case givenName = "given_name"
    }

    required init() {
        
    }
}

// MARK: - YHCertificates
class YHCertificates: SmartCodable {
    
    var cnIdentityCard: YHCNIdentityCard = YHCNIdentityCard()
    var passport: YHCNIdentityCard = YHCNIdentityCard()
    var hkMacaoPass: YHCNIdentityCard = YHCNIdentityCard()

    enum CodingKeys: String, CodingKey {
        case cnIdentityCard = "cnIdentityCard"
        case passport = "passport"
        case hkMacaoPass = "hkMacaoPass"
    }
        
    required init() {
        
    }
}

// MARK: - YHCNIdentityCard
class YHCNIdentityCard: SmartCodable {
    
    static let longTime = "8888-01-01"
    var id: Int = 0
    var number: String = ""
    var issueAt: String = ""
    var issueDateStartAt: String = ""
    var issueDateEndAt: String = "" {
        didSet {
            if !issueDateEndAt.isEmpty && issueDateEndAt != Self.longTime {
                lastIssueDateEndAt = issueDateEndAt
            }
        }
    }
    var lastIssueDateEndAt: String = ""
    var imgFront: String = ""
    var imgBack: String = ""
    var passPortType: Int = 0

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case number = "number"
        case issueAt = "issue_at"
        case issueDateStartAt = "issue_date_start_at"
        case issueDateEndAt = "issue_date_end_at"
        case imgFront = "img_front"
        case imgBack = "img_back"
        case passPortType = "passport_type"
    }
    
    required init() {
        
    }
}

// MARK: - YHHasDegreeJson
class YHHasDegreeJson: SmartCodable {
    
    var degree: String = ""
    var address: String = ""

    enum CodingKeys: String, CodingKey {
        case degree = "degree"
        case address = "address"
    }

    required init() {
        
    }
}
