//
//  YHFormItemDegreeInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/1/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemDegreeInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemDegreeInfoCell"
    let titleFont = UIFont.PFSC_M(ofSize: 16)
    
    var deleteBlock: (()->Void)?
    var degreeClickBlock:(()->Void)? {
        didSet {
            degreeView.clickBlock = degreeClickBlock
        }
    }
    var areaClickBlock:(()->Void)? {
        didSet {
            areaView.clickBlock = areaClickBlock
        }
    }
    var isNeed:Bool = true
    var title:String? {
        didSet {
            if let title = title, !title.isEmpty {
                let str = isNeed ? "*"+title : title
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: titleFont,
                    .foregroundColor: UIColor.mainTextColor]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                let starRange = NSRange(location: 0, length: 1)
                if isNeed {
                    questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                }
                titleLabel.attributedText = questionAttrStr
                
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    var degree:String? {
        didSet {
            degreeView.detail = degree
        }
    }
    
    var degreePlace:String? {
        didSet {
            areaView.detail = degreePlace
        }
    }
    
    func showTips(isShowDegreeTips:Bool, isShowPlaceTips:Bool) {
        degreeView.setTips("请选择学位".local, isShow:isShowDegreeTips)
        areaView.setTips("请选择颁发地区".local, isShow: isShowPlaceTips)
    }
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = titleFont
        return label
    }()
    
    lazy var deleteButton: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("删除", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(UIColor.failColor, for: .normal)
        btn.addTarget(self, action: #selector(didClickDeleteBtn(btn:)), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    lazy var degreeView:HKDegreeInfoItemView = {
        let view = HKDegreeInfoItemView(frame: .zero)
        return view
    }()
    
    lazy var areaView:HKDegreeInfoItemView = {
        let view = HKDegreeInfoItemView(frame: .zero)
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(titleLabel)
        contentView.addSubview(deleteButton)
        contentView.addSubview(degreeView)
        contentView.addSubview(areaView)
        
        titleLabel.text = "学位信息"
        degreeView.title = "学位证".local
        areaView.title = "颁发地区".local
        
        titleLabel.snp.makeConstraints { make in
            make.height.equalTo(52)
            make.top.equalToSuperview()
            make.left.equalToSuperview().offset(16)
            make.right.equalTo(deleteButton.snp.left)
        }
        
        deleteButton.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 64, height: 52))
            make.centerY.equalTo(titleLabel)
            make.right.equalToSuperview()
        }
        
        degreeView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(titleLabel.snp.bottom)
        }
        
        areaView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(degreeView.snp.bottom)
            make.bottom.equalToSuperview()
        }
    }
    
    func showDeleteBtn(_ show:Bool) {
        deleteButton.isHidden = !show
    }
    
    @objc func didClickDeleteBtn(btn:UIButton) {
        
        if let deleteBlock = deleteBlock {
            deleteBlock()
        }
    }
}

class HKDegreeInfoItemView: UIView {
    
    let horizonalGap = 18.0

    var placeHolder:String?
    var clickBlock:(()->Void)?
    let titleFont = UIFont.PFSC_R(ofSize: 14)
    
    var title:String? {
        didSet {
            if let title = title, !title.isEmpty {
                let str = "*"+title
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: titleFont,
                    .foregroundColor: UIColor.mainTextColor]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                let starRange = NSRange(location: 0, length: 1)
                questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                titleLabel.attributedText = questionAttrStr
                
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    var detail:String? {
        didSet {
            if let detail = detail, !detail.isEmpty {
                detailLabel.text = detail
                detailLabel.textColor = .mainTextColor
            } else {
                detailLabel.text = placeHolder
                detailLabel.textColor = .placeHolderColor
            }
        }
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.font = titleFont
        return label
    }()
    
    private lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 14)
        return label
    }()
    
    private lazy var arrowImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imgView
    }()
    
    private lazy var topLineView:UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0xF0F0F0)
        return view
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.isHidden = true
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    func createUI() {
        
        self.placeHolder = "请选择".local
        self.addSubview(titleLabel)
        self.addSubview(detailLabel)
        self.addSubview(arrowImgView)
        self.addSubview(topLineView)
        self.addSubview(tipsLabel)

        let tap = UITapGestureRecognizer(target: self, action:#selector(tap))
        self.addGestureRecognizer(tap)
        
        topLineView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.top.equalToSuperview()
            make.height.equalTo(1.0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(horizonalGap)
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalTo(detailLabel.snp.left).offset(-8)
            make.width.equalTo(120)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.right.equalTo(arrowImgView.snp.left)
            make.top.equalTo(titleLabel)
        }
        
        arrowImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(20, 20))
            make.right.equalToSuperview().offset(-horizonalGap)
            make.centerY.equalTo(detailLabel)
        }
        
        setTips("", isShow: false)
    }
    
    func setTips(_ tips:String?, isShow:Bool) {
        tipsLabel.text = tips
        tipsLabel.isHidden = !isShow
        if isShow {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(titleLabel.snp.bottom).offset(6)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(titleLabel.snp.bottom)
                make.height.equalTo(0)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    @objc func tap() {
        if let clickBlock = clickBlock {
            clickBlock()
        }
    }
}

