//
//  YHSingleLineSelectCell.swift
//  galaxy
//
//  Created by edy on 2024/1/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemEnterDetailCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemEnterDetailCell"
    let horizonalGap = 18.0

    private let titleFont: UIFont = UIFont.PFSC_M(ofSize: 14)
    private let titleColor:UIColor = .mainTextColor
    // 是否必填 如必填title会展示红色*
    var isMust = false
    var deleteBlock:(()->Void)?
    var isShowDeleteBtn:Bool = false {
        didSet {
            deleteButton.isHidden = !isShowDeleteBtn
            detailLabel.isHidden = isShowDeleteBtn
            arrowImgView.isHidden = isShowDeleteBtn
        }
    }
    // 是否隐藏顶部分割线
    var isHiddenTopLine:Bool = false {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }
    
    var title:String? {
        didSet {
            
            if let title = title, !title.isEmpty {
                let str = (isMust ? ("*"+title) : title)
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: titleFont,
                    .foregroundColor:titleColor
                ]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                if isMust {
                    let starRange = NSRange(location: 0, length: 1)
                    questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                }
                titleLabel.attributedText = questionAttrStr
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    var isNeedTopLineNoGap:Bool = false {
        didSet {
            let margin = isNeedTopLineNoGap ? 0 : horizonalGap
            topLine.snp.updateConstraints { make in
                make.left.equalToSuperview().offset(margin)
                make.right.equalToSuperview().offset(-margin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = titleColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = titleFont
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .labelTextColor2
        label.textAlignment = .right
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    private lazy var arrowImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imgView
    }()
    
    private lazy var deleteButton: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("删除".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.failColor, for: .normal)
        btn.addTarget(self, action: #selector(didClickDeleteBtn(btn:)), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    private lazy var topLine:UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        contentView.addSubview(tipsLabel)
        contentView.addSubview(arrowImgView)
        contentView.addSubview(deleteButton)
        contentView.addSubview(topLine)


        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalTo(detailLabel.snp.left).offset(-8)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.right.equalTo(arrowImgView.snp.left)
            make.width.equalTo(110.0)
            make.top.equalTo(titleLabel)
        }

        arrowImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(20, 20))
            make.right.equalToSuperview().offset(-horizonalGap)
            make.centerY.equalTo(detailLabel)
        }
        
        deleteButton.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(64, 40))
            make.centerY.equalTo(detailLabel)
            make.right.equalToSuperview()
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
        
        setTips("", isShow:false)
    }
    
    func setTips(_ tips:String?, isShow:Bool) {
        tipsLabel.text = tips
        tipsLabel.isHidden = !isShow
        if isShow {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(titleLabel.snp.bottom).offset(6)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            tipsLabel.snp.remakeConstraints { make in
                make.top.equalTo(titleLabel.snp.bottom)
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.height.equalTo(0)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    @objc func didClickDeleteBtn(btn:UIButton) {
        
        if let deleteBlock = deleteBlock {
            deleteBlock()
        }
    }
}
