//
//  YHOtherInfoSessionView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHOtherInfoSessionView: UIView {
    static let viewH : CGFloat = 52
    
    typealias Block = (Int) -> ()
    var block: Block?
    
    //0-默认只有title  1-带删除按钮  2-有subNameLabel  3-带默认图标
    var type : Int = 0 {
        didSet {
            
            if type == 1 {
                delButton.isHidden = false
            } else if type == 2 {
                subNameLable.isHidden = false
            } else if type == 3 {
                iconImageV.isHidden = false
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    //title
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "居住信息")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 17)
        return lable0
    }()
    
    private lazy var subNameLable : UILabel = {
        let lable0 = UILabel(text: "（是否有以下【辅助性】资料）")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 12)
        lable0.isHidden = true
        return lable0
    }()
    
    private lazy var bottomLine : UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0xF0F0F0)
        return view
    }()
    
    
    private lazy var iconImageV : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "other_info_warning")
        view.contentMode = .scaleAspectFill
        view.isHidden = true
        return view
    }()
    
    private lazy var delButton : UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("删除", for: .normal)
        btn.setTitleColor(UIColor.failColor, for: .normal)
        btn.titleLabel?.textAlignment = .right
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.isHidden = true
        return btn
    }()
    
    
    private func setupUI() {
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalToSuperview()
            make.bottom.equalTo(bottomLine.snp.top)
        }
        
        //subName
        addSubview(subNameLable)
        subNameLable.snp.makeConstraints { make in
            make.left.equalTo(nameLable.snp.right)
            make.centerY.equalTo(nameLable)
            make.height.equalTo(20)
        }
        
        //iconImageV
        addSubview(iconImageV)
        iconImageV.snp.makeConstraints { make in
            make.left.equalTo(nameLable.snp.right).offset(4)
            make.centerY.equalTo(nameLable)
            make.height.width.equalTo(16)
        }
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        iconImageV.isUserInteractionEnabled = true
        iconImageV.addGestureRecognizer(tap)
        
        //delButton
        addSubview(delButton)
        delButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalTo(nameLable)
            make.height.equalTo(44)
            make.width.equalTo(44)
        }
        delButton.addTarget(self, action: #selector(clickDeleteBtn), for: .touchUpInside)
    }
    
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        YHWholeScreenTipsView.show(type: .residenceInfo, targetView: iconImageV)
    }
}

extension YHOtherInfoSessionView {
    func updateTitle(title : String) {
        nameLable.text = title
    }
    
    @objc func clickDeleteBtn() {
        printLog("点击了 删除 按钮")
        YHSubmitAllInfoCheckView.showCheckView(tipMsg: "确认删除么?") { agree in
            if agree == true {
                self.block?(self.tag)
            } else {
                printLog("点击了 取消 按钮")
            }
        }
    }
}
