//
//  YHPreviewFamilyMemberViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 *家庭成员信息 预览
 */
class YHPreviewFamilyMemberViewController: YHPreviewBaseViewController {
    private let previewVM : YHPreviewViewModel =  YHPreviewViewModel()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        homeTableView.reloadData()
    }
    
    private var buttonHoldView : UIView  = {
        let view = UIView()
        return view
    }()
    
    private var parentButton : UIButton!
    private var spouseButton : UIButton!
    private var childrenButton : UIButton!
    private var brotherButton : UIButton!
    
    private var arrButtons : [UIButton] = []
}

private extension YHPreviewFamilyMemberViewController {
    func setupUI() {
        view.addSubview(buttonHoldView)
        buttonHoldView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(56)
        }
        
        
        spouseButton = createButton()
        spouseButton.setTitle("配偶", for: .normal)
        buttonHoldView.addSubview(spouseButton)
        spouseButton.snp.makeConstraints { make in
            
            make.centerY.equalToSuperview()
            make.left.equalToSuperview()
            make.height.equalTo(32)
            make.width.equalTo(68)
            
           
        }
        
        childrenButton = createButton()
        childrenButton.setTitle("子女", for: .normal)
        buttonHoldView.addSubview(childrenButton)
        childrenButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(spouseButton.snp.right).offset(12)
            make.height.equalTo(32)
            make.width.equalTo(68)
        }
        
        
        parentButton = createButton()
        parentButton.setTitle("父母", for: .normal)
        buttonHoldView.addSubview(parentButton)
        parentButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(childrenButton.snp.right).offset(12)
            make.height.equalTo(32)
            make.width.equalTo(68)
           
        }
        
        
       
        
        
        brotherButton = createButton()
        brotherButton.setTitle("兄弟姐妹", for: .normal)
        buttonHoldView.addSubview(brotherButton)
        brotherButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(parentButton.snp.right).offset(12)
            make.height.equalTo(32)
            make.width.equalTo(84)
        }
        
        
        arrButtons.append(parentButton)
        arrButtons.append(spouseButton)
        arrButtons.append(childrenButton)
        arrButtons.append(brotherButton)
        
        
        homeTableView.snp.removeConstraints()
        homeTableView.snp.makeConstraints { make in
            make.top.equalTo(buttonHoldView.snp.bottom)
            make.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        homeTableView.register(YHPreviewInfoCell.self,forCellReuseIdentifier: YHPreviewInfoCell.cellReuseIdentifier)
        homeTableView.reloadData()
    }
    
    
    private func layouButtons() {
        spouseButton.snp.removeConstraints()
        childrenButton.snp.removeConstraints()
        parentButton.snp.removeConstraints()
        brotherButton.snp.removeConstraints()
        
        var lastTagView : UIView? = nil
        
        //配偶
        if previewVM.arrDataForSpouse.isEmpty == false {
            spouseButton.isHidden = false
            spouseButton.snp.makeConstraints { make in
                make.centerY.equalToSuperview()
                make.left.equalToSuperview()
                make.height.equalTo(32)
                make.width.equalTo(68)
            }
            lastTagView = spouseButton
        } else {
            spouseButton.isHidden = true
        }
        
        
        //子女
        if previewVM.arrDataForChildren.isEmpty == false {
            childrenButton.isHidden = false
            
            if let lastTagView = lastTagView {
                childrenButton.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.left.equalTo(lastTagView.snp.right).offset(12)
                    make.height.equalTo(32)
                    make.width.equalTo(68)
                }
            } else {
                childrenButton.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.left.equalToSuperview()
                    make.height.equalTo(32)
                    make.width.equalTo(68)
                }
            }
            
            lastTagView = childrenButton
        } else {
            childrenButton.isHidden = true
        }
        
        
        
        
        //父母
        if previewVM.arrDataForParents.isEmpty == false {
            parentButton.isHidden = false
            if let lastTagView = lastTagView {
                parentButton.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.left.equalTo(lastTagView.snp.right).offset(12)
                    make.height.equalTo(32)
                    make.width.equalTo(68)
                }
            } else {
                parentButton.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.left.equalToSuperview()
                    make.height.equalTo(32)
                    make.width.equalTo(68)
                }
            }
            
            lastTagView = parentButton
        } else {
            parentButton.isHidden = true
        }
        
        
        
        //兄弟姐妹
        if previewVM.arrDataForBrother.isEmpty == false {
            brotherButton.isHidden = false
            if let lastTagView = lastTagView {
                brotherButton.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.left.equalTo(lastTagView.snp.right).offset(12)
                    make.height.equalTo(32)
                    make.width.equalTo(68)
                }
            } else {
                brotherButton.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.left.equalToSuperview()
                    make.height.equalTo(32)
                    make.width.equalTo(68)
                }
            }
            
            lastTagView = brotherButton
        } else {
            brotherButton.isHidden = true
        }
    }
    
    
    
    
    func createButton() -> UIButton {
        let btn = UIButton(type: .custom)
        btn.backgroundColor = UIColor.white
        btn.setTitleColor(.mainTextColor, for: .normal)
        btn.setTitleColor(.white, for: .selected)
        btn.layer.cornerRadius = 16
        btn.clipsToBounds = true
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
        
        btn.addTarget(self, action:#selector(clickButton(sender:)) , for: .touchUpInside)
        return btn
    }
    
    @objc func clickButton(sender : UIButton) {
        
        for button in arrButtons {
            button.backgroundColor = UIColor.white
            button.setTitleColor(.black, for: .normal)
        }
        sender.backgroundColor = .brandMainColor
        sender.setTitleColor(.white, for: .normal)
        
        if sender == parentButton {
            previewVM.arrDataForMainApplicationInfo = previewVM.arrDataForParents
        } else if sender == childrenButton {
            previewVM.arrDataForMainApplicationInfo = previewVM.arrDataForChildren
        } else if sender == brotherButton {
            previewVM.arrDataForMainApplicationInfo = previewVM.arrDataForBrother
        } else if sender == spouseButton {
            previewVM.arrDataForMainApplicationInfo = previewVM.arrDataForSpouse
        } else {
            previewVM.arrDataForMainApplicationInfo = []
        }
        homeTableView.reloadData()
    }
    
    
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            previewVM.getPreviewForFamilyInfo(params: ["order_id" : orderID]) { success, error in
                if success == true {
                } else {
                    
                }
                self.layouButtons()
                self.highlightButton()
                self.homeTableView.reloadData()
                return
            }
        } else {
            printLog("error : orderID 为空")
        }
        self.layouButtons()
        self.homeTableView.reloadData()
    }
    
    private func highlightButton() {
        if !spouseButton.isHidden {
            clickButton(sender:spouseButton)
            clickButton(sender:spouseButton)
            return
        }
        
        if !childrenButton.isHidden {
            clickButton(sender:childrenButton)
            return
        }
        
        if !parentButton.isHidden {
            clickButton(sender:parentButton)
            return
        }
        
        if !brotherButton.isHidden {
            clickButton(sender:brotherButton)
            return
        }
        
    }
}



// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHPreviewFamilyMemberViewController {
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return previewVM.arrDataForMainApplicationInfo.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHPreviewInfoCell.self)
        cell.selectionStyle = .none
        cell.model = previewVM.arrDataForMainApplicationInfo[indexPath.row]
        return cell
    }
}

