//
//  YHPreviewInfoProjectItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoProjectItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var dataModel : YHWorkExpDataModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoProjectItemView {
    func updateUI() {
        guard let model = dataModel else { return }
        removeSubviews()
        
        let sessionView : UILabel = UILabel()
        sessionView.text = model.title
        sessionView.font = UIFont.PFSC_R(ofSize: 14)
        sessionView.textColor = UIColor.labelTextColor2
        addSubview(sessionView)
        sessionView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.right.equalToSuperview().offset(-kMargin)
            make.left.equalToSuperview().offset(kMargin)
            make.height.equalTo(20)
        }
        sessionView.backgroundColor = .clear
        
        let holdView : YHPreviewInfoHoldView = YHPreviewInfoHoldView()
        holdView.backgroundColor = .contentBkgColor
        addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.equalTo(sessionView.snp.bottom).offset(8)
            make.right.equalToSuperview().offset(-kMargin)
            make.left.equalToSuperview().offset(kMargin)
            make.bottom.equalToSuperview()
        }
        
        var lastTagView : UIView? = nil
        if model.data.isEmpty == false {
            let item: YHPreviewInfoSessionModel = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "", cellData0:model.data as? [YHPreviewQuestionAndAnswerModel])
            let view = YHPreviewInfoQuestionAndAnswerItemsView(frame: .zero)
            view.dataModel = item
            holdView.addSubview(view)
            view.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.right.equalToSuperview()
                make.bottom.equalToSuperview()
            }
            lastTagView = view
        }
        
        let tagView : UIView = UIView()
        tagView.backgroundColor = .failColor
        holdView.addSubview(tagView)
        if lastTagView == nil {
            tagView.snp.makeConstraints { make in
                make.top.equalTo(6)
                make.left.right.equalToSuperview()
                make.height.equalTo(1)
                
                make.bottom.equalToSuperview()
            }
        } else {
            tagView.snp.makeConstraints { make in
                make.top.equalTo(lastTagView!.snp.bottom).offset(6)
                make.left.right.equalToSuperview()
                make.height.equalTo(1)
                
                make.bottom.equalToSuperview()
            }
        }
    }
}
