//
//  YHWorkActionView.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkActionView: UIView {
    typealias ExampleBlock = () -> ()
    typealias PhotoBlock = () -> ()
    var exampleBlock: ExampleBlock?
    var photoBlock: PhotoBlock?
    var photoButton: UIButton!
//    var wxButton: UIButton!
    var exampleButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        
        photoButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "work_experience_photo"), for: .normal)
            button.addTarget(self, action: #selector(photoClick), for: .touchUpInside)
            return button
        }()
        addSubview(photoButton)
        photoButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(16)
            make.height.width.equalTo(21)
        }
        
//        wxButton = {
//            let button = UIButton(type: .custom)
//            button.setBackgroundImage(UIImage(named: "work_experience_wx"), for: .normal)
//            button.addTarget(self, action: #selector(wxClick), for: .touchUpInside)
//            return button
//        }()
//        addSubview(wxButton)
//        wxButton.snp.makeConstraints { make in
//            make.centerY.equalToSuperview()
//            make.left.equalTo(49)
//            make.height.width.equalTo(21)
//        }
        
        exampleButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
            button.contentHorizontalAlignment = .center
            button.setTitle("参考示例", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.setImage(UIImage(named: "work_experience_example"), for: .normal)
            button.imageEdgeInsets = UIEdgeInsets(top: 2, left: 0, bottom: 2, right: 58)
            button.addTarget(self, action: #selector(exampleClick), for: .touchUpInside)
            
            return button
        }()
        addSubview(exampleButton)
        exampleButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-18)
            make.height.equalTo(20)
            make.width.equalTo(74)
        }
        
    }
    
    @objc func photoClick() {
        if let block = photoBlock {
            block()
        }
    }
    
    @objc func wxClick() {
        
    }
    
    @objc func exampleClick() {
        if let block = exampleBlock {
            block()
        }
    }
}
