//
//  YHInformationPerfectCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit


class YHInformationPerfectCell: UITableViewCell {
    static let cellReuseIdentifier = "YHInformationPerfectCell"
    static let cellHeight :CGFloat = 82
    
    var dataModel : YHInformationPerfectModel? {
        didSet {
            updateUI()
        }
    }
    
    private lazy var topImagV : UIImageView = {
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "top_image")
        nextImgV.contentMode = .scaleAspectFill
        nextImgV.clipsToBounds = true
        return nextImgV
    }()
    
    private lazy var midImagV : UIImageView = {
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "mid_image")
        nextImgV.contentMode = .scaleAspectFill
        nextImgV.clipsToBounds = true
        return nextImgV
    }()
    
    private lazy var bottomImagV : UIImageView = {
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "bottom_image")
        nextImgV.contentMode = .scaleAspectFill
        nextImgV.clipsToBounds = true
        return nextImgV
    }()
    
    
    private lazy var itemImagV : UIImageView = {
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "zsqr_icon")
        nextImgV.contentMode = .scaleAspectFill
        return nextImgV
    }()
    
    
    private lazy var itemNameLable : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.font = UIFont.PFSC_M(ofSize: 16)
        lable.text = "主申请人信息"
        return lable
    }()
    
    
    private lazy var itemStatusLable : UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.successColor
        lable.font = UIFont.PFSC_M(ofSize: 14)
        lable.text = "已完成"
        lable.textAlignment = .right
        return lable
    }()
    
    
    
    private lazy var nextImgV : UIImageView = {
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "service_center_right_next_icon")
        nextImgV.contentMode = .scaleAspectFill
        return nextImgV
    }()
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

extension YHInformationPerfectCell {
    func updateUI() {
        itemNameLable.text = dataModel?.name
        itemNameLable.textColor = dataModel?.color
        if dataModel?.isDoing == true {
            itemNameLable.textColor = UIColor.mainTextColor
        }
        
        itemStatusLable.text = dataModel?.status
        itemStatusLable.textColor = dataModel?.statusColor
        
        itemImagV.image = UIImage(named: dataModel?.icon ?? "")
        
        
        
        
        //topImagV
        if dataModel?.isFirstCell == true {
            topImagV.isHidden = true
        } else {
            topImagV.isHidden = false
            
            if dataModel?.isFinished == true {
                topImagV.image = UIImage(named: "top_image")
            } else {
                if dataModel?.isDoing == true {
                    topImagV.image = UIImage(named: "top_image")
                } else {
                    topImagV.image = UIImage(named: "bottom_image")
                }
            }
        }
        
        //middle
        if dataModel?.isFinished == true {
            midImagV.image = UIImage(named: "mid_image")
            contentView.layer.opacity = 1.0
        } else {
            if dataModel?.isDoing == true {
                midImagV.image = UIImage(named: "mid_image1")
                contentView.layer.opacity = 1.0
            } else {
                midImagV.image = UIImage(named: "mid_image2")
                contentView.layer.opacity = 0.4
            }
        }
        
        
        //bottom
        if dataModel?.isLastestCell == true {
            bottomImagV.isHidden = true
        } else {
            bottomImagV.isHidden = false
            if dataModel?.isFinished == true {
                bottomImagV.image = UIImage(named: "top_image")
            } else {
                bottomImagV.image = UIImage(named: "bottom_image")
            }
            
        }
    }
    
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(midImagV)
        midImagV.layer.zPosition = 10
        midImagV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(kMargin)
            make.width.height.equalTo(14)
        }
        
        
        contentView.addSubview(topImagV)
        topImagV.snp.makeConstraints { make in
            make.centerX.equalTo(midImagV)
            make.top.equalToSuperview()
            make.bottom.equalTo(midImagV.snp.top).offset(-4)
            make.width.equalTo(2)
        }
        
        
        contentView.addSubview(bottomImagV)
        bottomImagV.snp.makeConstraints { make in
            make.centerX.equalTo(midImagV)
            make.top.equalTo(midImagV.snp.bottom).offset(4)
            make.width.equalTo(2)
            make.bottom.equalToSuperview()
        }
        
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.height.equalTo(68)
            make.right.equalTo(-kMargin)
            make.left.equalTo(midImagV.snp.right).offset(16)
        }
        
        
        holdView.addSubview(itemImagV)
        itemImagV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(21)
            make.width.height.equalTo(21)
        }
        
        holdView.addSubview(nextImgV)
        nextImgV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.width.height.equalTo(16)
        }
        
        
        holdView.addSubview(itemStatusLable)
        itemStatusLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(nextImgV.snp.left).offset(-4)
            make.height.equalTo(20)
        }
        
        holdView.addSubview(itemNameLable)
        itemNameLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(itemStatusLable.snp.left).offset(-10)
            make.height.equalTo(20)
            make.left.equalTo(itemImagV.snp.right).offset(12)
        }
    }
}
