//
//  YHServiceTableFootView.swift
//  galaxy
//
//  Created by EDY on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceTableFootView: UIView {
    typealias LoadBlock = () -> ()
    var moreBlock: LoadBlock?
    typealias ScrollBlock = (Bool) -> ()
    var scrollBlock: ScrollBlock?
    var isNeedScrollBlock: Bool = false
    var items:[YHHomeListModel?] = [] {
        didSet {
            self.myCollectView.reloadData()
        }
    }
    
    lazy var myCollectView = {
        // 设置布局方向
        let flowLayout = YHHomeCollectionLayout()
        flowLayout.minimumInteritemSpacing = 7.0
        flowLayout.minimumColumnSpacing = 7.0
        flowLayout.sectionInset = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        let collectinoView = YHGestureCollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .white
        collectinoView.register(YHHomeCollectionViewCell.self, forCellWithReuseIdentifier:YHHomeCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
//        collectinoView.bounces = false
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.showsVerticalScrollIndicator = false
        collectinoView.showsHorizontalScrollIndicator = false
        return collectinoView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .white
        addSubview(myCollectView)
        myCollectView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
        
        myCollectView.es.addInfiniteScrolling {[weak self] in
            guard let self = self else { return }
            if let block = moreBlock {
                block()
            }
        }
    }
}

extension YHServiceTableFootView: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return items.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHHomeCollectionViewCell.cellReuseIdentifier, for: indexPath) as! YHHomeCollectionViewCell
        cell.listModel = items[indexPath.row]
        return cell
        
    }
    
    private func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        print("index is \(indexPath.row)")
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        guard let model = items[indexPath.row] else { return }
        if model.type == 2 {
            let vc = YHHomeWebViewController()
            vc.url = YHBaseUrlManager.shared.curH5URL() + "articleDetail.html" + "?id=\(model.id)"
            vc.id = model.id
            vc.block = {[weak self] model in
                guard let self = self else { return }
                let arr = self.items
                for (index, targetItem) in arr.enumerated() {
                    guard let target = targetItem else { return }
                    if target.id == model.id {
                        target.is_like = model.is_like
                        target.like_count = model.like_count
                        self.myCollectView.reloadItems(at: [IndexPath.SubSequence(item: index, section: 0)])
                    }
                }
            }
            UIViewController.current?.navigationController?.pushViewController(vc)
        } else if model.type == 1 {
            printLog("直接播放视频")
        }
    }
    
//    func scrollViewDidScroll(_ scrollView: UIScrollView) {
//        if scrollView == myCollectView, isNeedScrollBlock == true {
//            let offsetY = myCollectView.contentOffset.y
//            if offsetY <= 0 {
//                myCollectView.isScrollEnabled = false
//                if let block = scrollBlock {
//                    block(true)
//                }
//            } else {
//                myCollectView.isScrollEnabled = true
//                if let block = scrollBlock {
//                    block(false)
//                }
//            }
//        }
//    }
//    
//    func scrollViewDidEndDragging(_ scrollView: UIScrollView, willDecelerate decelerate: Bool) {
//        // 用户停止拖拽时调用，可以执行一些后续操作
//        if scrollView == myCollectView, isNeedScrollBlock == true  {
//            let offsetY = myCollectView.contentOffset.y
//            if offsetY <= 0 {
//                myCollectView.isScrollEnabled = false
//                if let block = scrollBlock {
//                    block(true)
//                }
//            } else {
//                myCollectView.isScrollEnabled = true
//                if let block = scrollBlock {
//                    block(false)
//                }
//            }
//        }
//    }
//    
//    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView) {
//        // 滚动减速完成时调用，表示滚动完全停止
//        if scrollView == myCollectView, isNeedScrollBlock == true  {
//            let offsetY = myCollectView.contentOffset.y
//            if offsetY <= 0 {
//                myCollectView.isScrollEnabled = false
//                if let block = scrollBlock {
//                    block(true)
//                }
//            } else {
//                myCollectView.isScrollEnabled = true
//                if let block = scrollBlock {
//                    block(false)
//                }
//            }
//        }
//    }
    
}

extension YHServiceTableFootView: CollectionViewWaterfallLayoutDelegate {
    func collectionView(_ collectionView: UICollectionView, layout: UICollectionViewLayout, sizeForItemAtIndexPath indexPath: NSIndexPath) -> CGSize {
        guard let model = items[indexPath.row] else { return CGSize.zero }
        return CGSize(width: model.img_width_cell, height: model.img_height_cell)
    }
}
