//
//  YHSubmintAllInfoSuccessTipView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHSubmintAllInfoSuccessTipView: UIView {
    typealias Block = (Bool) -> ()
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    var model : YHContactInfoScoreModel? {
        didSet {
            guard let model = model else {
                return
            }
            let a: ASAttributedString = .init(NSAttributedString(string: model.sum_score), .font(UIFont(name: "DINAlternate-Bold", size: 43) ?? UIFont.PFSC_M(ofSize: 43)),.foreground(UIColor.warnColor))
            let b: ASAttributedString = .init("分", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
            messageLabel.attributed.text = a + b
        }
    }
    
    //头部背景图片
    lazy var headBkgImagV: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "submit_success_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    //头部背景图片
    lazy var successIcon: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "submit_success_icon")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    
    static func showCheckView(model: YHContactInfoScoreModel?,callBack: @escaping Block) {
        let view = YHSubmintAllInfoSuccessTipView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.block = callBack
        view.model = model
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            make.height.equalTo(338)
        }
        
        
        centerView.addSubview(headBkgImagV)
        headBkgImagV.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(159)
        }
        
        
        centerView.addSubview(successIcon)
        successIcon.snp.makeConstraints { make in
            make.top.equalTo(39)
            make.centerX.equalToSuperview()
            make.height.width.equalTo(73)
        }
        
        
        let lable = UILabel(text: "提交成功")
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.textColor = UIColor.mainTextColor
        
        headBkgImagV.addSubview(lable)
        lable.snp.makeConstraints { make in
            make.bottom.equalToSuperview().offset(6)
            make.left.right.equalToSuperview()
        }
        
        
        
        let lable2 = UILabel(text: "根据您填写的资料，您的评分如下：")
        lable2.textAlignment = .center
        lable2.font = UIFont.PFSC_R(ofSize: 14)
        lable2.textColor = UIColor.mainTextColor
        
        centerView.addSubview(lable2)
        lable2.snp.makeConstraints { make in
            make.top.equalTo(headBkgImagV.snp.bottom).offset(10)
            make.left.right.equalToSuperview()
        }
        
    
        messageLabel = {
            let label = UILabel()
            label.text = "--分"
            label.textAlignment = .center
            label.numberOfLines = 1
            return label
        }()
        messageLabel.backgroundColor = .clear
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.top.equalTo(lable2.snp.bottom).offset(10)
            make.left.right.equalToSuperview()
            make.height.equalTo(50)
        }
        
        let a: ASAttributedString = .init("90", .font(UIFont.PFSC_M(ofSize: 43)),.foreground(UIColor.warnColor))
        let b: ASAttributedString = .init("分", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
        messageLabel.attributed.text = a + b
        
        disAgressButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  .white
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("取消", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(disAgressButton)
        disAgressButton.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
        agreeButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("评分详情", for: .normal)
            button.setTitleColor(.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(agree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.right.equalTo(-kMargin)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        agreeButton.layoutIfNeeded()
        agreeButton.addYinHeGradualLayer()
        
    }
    
    @objc func agree() {
        block?(true)
        dismiss()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func disagree() {
        block?(false)
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHSubmintAllInfoSuccessTipView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
