//
//  YHSubmitAllInfoSuccessAlertView.swift
//  galaxy
//
//  Created by edy on 2024/5/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString
import YYImage

class YHSubmitAllInfoSuccessAlertView: UIView {
    
    typealias Block = (Bool) -> ()
    let scoreBigFont = UIFont.PFSC_B(ofSize: 50)
    let scoreSmallFont = UIFont.PFSC_R(ofSize: 13)
    let scoreBigColor = UIColor.brandMainColor
    let scoreSmallColor = UIColor.init(hex: 0x000000)
    var block: Block?
    var centerView: UIView!
    var scoreLabel: UILabel!
    var cancelButton: UIButton!
    var detailButton: UIButton!
    
    var model : YHContactInfoScoreModel? {
        didSet {
            guard let model = model else {
                return
            }
            let a: ASAttributedString = .init(NSAttributedString(string: model.sum_score), .font(self.scoreBigFont),.foreground(self.scoreBigColor))
            let b: ASAttributedString = .init("分", .font(self.scoreSmallFont),.foreground(self.scoreSmallColor))
            scoreLabel.attributed.text = a + b
        }
    }
    
    //头部背景图片
    lazy var headBkgImagV: UIImageView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "submit_success_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    lazy var headImgV: YYAnimatedImageView = {
        let img = YYImage(named:"submit_head_animation.gif")
        let imgV = YYAnimatedImageView(image: img)
        return imgV
    }()
    
    lazy var scrollBgImgV:YYAnimatedImageView =  {
        let img = YYImage(named:"submit_page_scroll.gif")
        let imgV = YYAnimatedImageView(image: img)
        imgV.autoPlayAnimatedImage = false
        imgV.currentAnimatedImageIndex = 0
        return imgV
    }()
    
    static func showCheckView(model: YHContactInfoScoreModel?,callBack: @escaping Block) {
        let view = YHSubmitAllInfoSuccessAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.block = callBack
        view.model = model
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .green
            view.layer.cornerRadius = kCornerRadius8
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            make.height.equalTo(375)
        }
        
        centerView.addSubview(scrollBgImgV)
        centerView.addSubview(headImgV)

        headImgV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        scrollBgImgV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        scoreLabel = {
            let label = UILabel()
            label.text = "--分"
            label.textAlignment = .left
            label.numberOfLines = 1
            return label
        }()
        scoreLabel.backgroundColor = .clear
        centerView.addSubview(scoreLabel)
        scoreLabel.snp.makeConstraints { make in
            make.bottom.equalTo(-45)
            make.left.equalTo(20)
            make.height.equalTo(55)
        }
        
        let a: ASAttributedString = .init("0", .font(self.scoreBigFont), .foreground(scoreBigColor))
        let b: ASAttributedString = .init("分", .font(scoreSmallFont), .foreground(scoreSmallColor))
        scoreLabel.attributed.text = a + b
        
        cancelButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "update_close"), for: .normal)
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        self.addSubview(cancelButton)
        cancelButton.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerX.equalTo(self)
            make.top.equalTo(centerView.snp.bottom).offset(20)
        }

        detailButton = {
           let btn = UIButton()
           btn.addTarget(self, action: #selector(agree), for: .touchUpInside)
           return btn
        }()
        centerView.addSubview(detailButton)
        detailButton.snp.makeConstraints { make in
            make.width.equalTo(72)
            make.height.equalTo(55)
            make.bottom.right.equalToSuperview()
        }
        
        DispatchQueue.main.asyncAfter(wallDeadline: .now() + 1) {
            self.scrollBgImgV.startAnimating()
        }
    }
    
    @objc func agree() {
        block?(true)
        dismiss()
    }
    
    @objc func disagree() {
        block?(false)
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}
