//
//  YHLoginPrivacyView.swift
//  galaxy
//
//  Created by EDY on 2023/12/26.
//

import UIKit

class YHLoginPrivacyView: UIView {

    var agreeButton: UIButton!
    var messageLabel: UILabel!
    var serviceButton: UIButton!
    var andLabel: UILabel!
    var privacyButton: UIButton!
    var isAgree: Bool = false {
        didSet{
            agreeButton.isSelected = isAgree
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        agreeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "login_privacy_disagree_glay"), for: .normal)
            button.setBackgroundImage(UIImage(named: "login_privacy_agree"), for: .selected)

            button.addTarget(self, action: #selector(agreeClick), for: .touchUpInside)
            return button
        }()
        addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview()
            make.height.equalTo(12)
            make.width.equalTo(12)
        }
        
        messageLabel = {
            let label = UILabel()
            label.text = "我已阅读并同意"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.textAlignment = .left
            return label
        }()
        addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(agreeButton.snp.right).offset(10)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
        }
        
        serviceButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.contentHorizontalAlignment = .center
            button.setTitle("《隐私协议》", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(firstUrlClick), for: .touchUpInside)
            return button
        }()
        addSubview(serviceButton)
        serviceButton.snp.makeConstraints { make in
            make.left.equalTo(messageLabel.snp.right).offset(1)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(80)
        }
        andLabel = {
            let label = UILabel()
            label.text = "和"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.textAlignment = .left
            return label
        }()
        addSubview(andLabel)
        andLabel.snp.makeConstraints { make in
            make.left.equalTo(serviceButton.snp.right).offset(1)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
        }
        privacyButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.contentHorizontalAlignment = .center
            button.setTitle("《用户条款》", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(secondUrlClick), for: .touchUpInside)
            return button
        }()
        addSubview(privacyButton)
        privacyButton.snp.makeConstraints { make in
            make.left.equalTo(andLabel.snp.right).offset(1)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(80)
        }
        
        
        
        agreeButton.YH_clickEdgeInsets = UIEdgeInsets(top: 50, left: 50, bottom: 50, right: 50)
        serviceButton.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 0, bottom: 20, right: 0)
        privacyButton.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 0, bottom: 20, right: 0)

    }
    
    @objc func agreeClick() {
        agreeButton.isSelected = !agreeButton.isSelected
        isAgree = agreeButton.isSelected
    }
    
    @objc func firstUrlClick() {
        let vc = YHWebViewViewController()
        vc.url = YHBaseUrlManager.shared.curPrivacyAgreementUrl()
        vc.navTitle = "银河港生活隐私协议"
        UIViewController.current?.navigationController?.pushViewController(vc)
    }
    
    @objc func secondUrlClick() {
        let vc = YHWebViewViewController()
        vc.url = YHBaseUrlManager.shared.curUserItemsUrl()
        vc.navTitle = "银河港生活用户条款"
        UIViewController.current?.navigationController?.pushViewController(vc)
    }
}
