//
//  YHVideoPlaySettingVC.swift
//  galaxy
//
//  Created by edy on 2024/6/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

let kVideoPlaySilentSettingKey = "kVideoPlaySilentSettingKey"


func getVideoPlaySilentSettings() -> Bool {
    // 默认不静音
    let playSlicent = UserDefaults.standard.bool(forKey: kVideoPlaySilentSettingKey)
    return playSlicent
}

func saveVideoPlaySilentSetting(_ silent: Bool) {
    UserDefaults.standard.set(silent, forKey: kVideoPlaySilentSettingKey)
    UserDefaults.standard.synchronize()
}

class YHVideoPlaySettingVC: YHBaseViewController {

    lazy var titleLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString:"#121A26")
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize:15)
        label.text = "播放视频时默认静音"
        return label
    }()
    
    lazy var switchBtn:UISwitch = {
        let switchBtn = UISwitch()
        switchBtn.onTintColor =  UIColor.brandMainColor
        switchBtn.addTarget(self, action: #selector(switchViewChange), for: .valueChanged)
        switchBtn.tintColor = .brandMainColor
        switchBtn.isOn = getVideoPlaySilentSettings()
        return switchBtn
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    @objc func switchViewChange() {
        saveVideoPlaySilentSetting(switchBtn.isOn)
    }
    
    func setupUI() {
        gk_navTitle = "播放设置".local
        view.backgroundColor = .white
        
        let itemView = UIView()
        itemView.backgroundColor = .white
        view.addSubview(itemView)
        itemView.addSubview(titleLabel)
        
        let btnView = UIView()
        btnView.addSubview(switchBtn)
        itemView.addSubview(btnView)

        itemView.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(53.0)
        }

        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(switchBtn.snp.left).offset(-21)
            make.centerY.equalToSuperview()
        }
        
        btnView.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.centerY.equalToSuperview()
            make.height.equalTo(22)
            make.width.equalTo(btnView.snp.height).multipliedBy(5.0/3.0)
        }
    }
    
    override func viewWillLayoutSubviews() {
        super.viewWillLayoutSubviews()
        switchBtn.transform = CGAffineTransform(scaleX: 0.70, y: 0.70)
        switchBtn.snp.updateConstraints { make in
            make.left.equalTo(-7)
            make.centerY.equalToSuperview()
        }
    }

}
