//
//  YHAppVersionManager.swift
//  galaxy
//
//  Created by edy on 2024/5/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

// 本地存储日期 当天是否显示过建议更新最新版本红点提示的日期
let kShowRedPointOfSuggestLatestVersionDate =  "show_redpoint_suggest_latest_version_date"
let appId = "6502422466"

class YHAppVersionManager {

    static let shared = YHAppVersionManager()
    
    func goToAppStore() {
        // 替换为你要打开的 App Store 中的应用程序链接
        let appStoreLink = "https://itunes.apple.com/app/\(appId)"
        // 使用该链接创建一个 URL 实例
        if let url = URL(string: appStoreLink) {
            if UIApplication.shared.canOpenURL(url) {
                UIApplication.shared.open(url, options: [:], completionHandler: nil)
            } else {
                YHHUD.flash(message: "无法打开AppStore链接~")
            }
        }
    }
    
    // 是否需要显示建议版本更新红点
    func needShowRedPointOfSuggestVersionUpdate() -> Bool {
        var isShowRedPoint = false
        
        // 判断版本更新逻辑
        if let configModel = YHConfigManager.shared.reqVM.configModel, configModel.suggest_updating == true {
            if configModel.max_version != UIDevice.appVersion() {
                
                if let showDateString = UserDefaults.standard.object(forKey: kShowRedPointOfSuggestLatestVersionDate) as? String {
                    if !showDateString.isEmpty, showDateString != self.getCurrentDateSaveKey() { // 需要更新且今天没有展示过
                        isShowRedPoint = true
                    }
                    
                } else { // 没有任何一天展示过所以本地没有保存日期数据
                    isShowRedPoint = true
                }
            }
        }
        return isShowRedPoint
    }
    
    // 是否需要显示建议版本更新弹窗
    func needShowAlertViewOfSuggestVersionUpdate() -> Bool {
        var isShow = false
        if let configModel = YHConfigManager.shared.reqVM.configModel, configModel.suggest_updating == true {
            if let alertLatestVersion = UserDefaults.standard.object(forKey: kShowAlertOfSuggestLatestVersion) as? String {
                if !configModel.max_version.isEmpty, configModel.max_version != alertLatestVersion  {
                    isShow = true
                }
            } else {
                isShow = true
            }
        }
        return isShow
    }
    
    func getCurrentDateSaveKey() -> String {
        let format = DateFormatter()
        format.dateFormat = "yyyy-MM-dd"
        let todayString = format.string(from: Date())
        return todayString
    }
    
    // 保存今天已显示建议版本更新红点本地日期数据 如果有建议更新每天只显示一次
    func saveTodayShowSuggestVersionUpdateRedPoint() {
        UserDefaults.standard.set(self.getCurrentDateSaveKey(), forKey: kShowRedPointOfSuggestLatestVersionDate)
        UserDefaults.standard.synchronize()
    }
    
    // 保存显示过的最新建议升级弹窗的app版本
    func saveShowLatestUpdateVersion () {
        if let configModel = YHConfigManager.shared.reqVM.configModel {
            UserDefaults.standard.set(configModel.max_version, forKey: kShowAlertOfSuggestLatestVersion)
            UserDefaults.standard.synchronize()
        }
    }
}
