//
//  BsAllApiName.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2024/01/04.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//


class YHAllApiName {
    //接口 模块名 Common
    struct Common {
        //首页配置接口
        static let homeConfigApi = "super-app/config/app"
        //获取首页展示的资讯
        static let consultApi = "infoflow/home/consult"
        //获取首页展示的banner
        static let banner = "infoflow/banner/list"
        //获取栏目
        static let classify = "infoflow/classify/list"
        //获取资讯
        static let article = "infoflow/article/list"
        //资讯详情
        static let webInfo = "infoflow/article/info"
        //资讯收藏
        static let star = "infoflow/article/collect"
        //资讯点赞
        static let like = "infoflow/article/like"
        //我的点赞和收藏
        static let user = "infoflow/user/consult"
        //我的浏览
        static let userLook = "infoflow/user/view"
        //获取香港办事
        static let hklist = "infoflow/tool/list"
        // 点赞、收藏、最近浏览数量
        static let likeCollect = "infoflow/article/myArticleRecord"
    }
    
    //order 模块
    struct Order {
        //合同列表
        static let contractListApi = "infoflow/order/list"
        
        
        //合同填写进度
        static let contractStatusApi = "infoflow/order/progress"
        
        //信息表的填写进度
        static let informationStepApi = "infoflow/order/information/step"
        
        //提交订单信息
        static let submitAllInfoApi = "infoflow/order/information/submit"
        
        
        //我的评分结果
        static let scoreDetailApi = "infoflow/orderAssessment/scoreDetail"
        
        
        //获取其他资料填写信息
        static let otherInfoFillApi = "infoflow/order/getOrderOtherInformation"
        //保存其他资料信息
        static let  updateOtherInfoApi = "infoflow/order/updateOrderOtherInformation"
        
        //服务中心进度列表
        static let serviceCenterProgressApi = "infoflow/order/service-list"
        //搜索白名单
        static let bywhitelist = "infoflow/permissiondict/bywhitelist"
        static let byorderid = "infoflow/order/byorderid"
    }
    
    struct Family {
        // 获取家庭成员信息 添加家庭成员也用这个
        static let familyInfoApi = "infoflow/information/family"
        // 删除家庭成员信息
        static let deleteFamilyMemberApi = "infoflow/family/delete"
        // 提交家庭成员信息
        static let submitAllFamilyInfoApi = "infoflow/family/submit"
        // 某个家庭成员性情
        static let familyInfoDetailApi = "infoflow/information/member"
    }
    
    struct Education {
        // 获取教育和专业资格列表
        static let getEducationAndQulificationInfoListApi = "infoflow/getEducationList"
        // 获取学历详情信息
        static let getEducationDetailInfoApi = "infoflow/getEducationDetail"
        // 保存学历信息
        static let saveEducationInfoApi = "infoflow/saveEducationData"
        // 删除学历
        static let deleteEducationInfoApi = "infoflow/delEducationData"
        // 保存所有信息
        static let saveAllEduAndQuaInfoApi = "infoflow/submitEducert"
        // 搜索大学名称
        static let searchCollegeNameApi = "infoflow/getSchools"
        
    }
    
    struct Qualification {
        // 获取学历详情信息
        static let getQualificationDetailInfoApi = "infoflow/getQuaDetail"
        // 删除专业
        static let deleteQualificationInfoApi = "infoflow/delQualification"
        // 保存专业详情
        static let saveQualificationInfoApi =  "infoflow/saveQualification"
        
    }
    
    //Users
    struct Users {
        //提交 温馨提示信息
        static let submitSweetNotifyApi = "infoflow/users/sweet-notify/submit"
    }
    
    
    
    //Basics
    struct Basics {
        //获取 基本资料信息
        static let basicInfoApi = "infoflow/basics/get_basics"
        
        //保存基本资料信息
        static let  updateBasicInfoApi = "infoflow/basics/update_basics"
    }
    
    struct OrderInformation {
        //主申请人获取信息
        static let getInformation = "infoflow/order-information/get_information"
        // 主申请人信息更新
        static let updateInformation = "infoflow/order-information/update_information"
        // 主申请人国家信息
        static let countryInformation = "infoflow/country"
        // 主申请人中国
        static let cnIdCard = "infoflow/order-information/get_id_card"
        // 主申请人港澳通行证
        static let hkIdCard = "infoflow/order-information/get_hk_macao_pass"
    }
    
    struct WorkExperience {
        //工作经验列表
        static let list = "infoflow/work/list"
        //工作经验详情
        static let detail = "infoflow/work/detail"
        //工作经验保存
        static let save = "infoflow/work/save"
        static let saveAll = "infoflow/work/save-all"
        //公司列表
        static let company = "infoflow/company/search"
        //工作经历删除
        static let del = "infoflow/work/del"
        //工作经历参考模版
        static let example = "infoflow/work/getWorkExampleList"
        static let projectExample = "infoflow/work/getWorkProjectExampleList"
        //工作经验项目保存
        static let saveProject = "infoflow/work/saveWorkProject"
        //工作经验项目列表
        static let projectList = "infoflow/work/getWorkProjectList"
        //工作经验项目列表
        static let projectDetail = "infoflow/work/getWorkProjectDetail"
        //删除工作经验项目
        static let projectDel = "infoflow/work/delWorkProject"
        //识别附件
        static let ocrFileContent = "infoflow/work/getOcrFileContent"
        //已上传文件列表
        static let fileList = "infoflow/work/file-list"
    }
    
    //登录
    struct Auth {
        static let login = "infoflow/auth/login"
        static let wxlogin = "infoflow/auth/wechat-login"
        static let oneKeyLogin = "infoflow/auth/native-login"
        static let appleLogin = "infoflow/auth/apple-login"
        static let oneKeySecretKeyInfo = "infoflow/auth/sdk-info"
        static let logout = "infoflow/auth/logout"
        //注销app
        static let unregisterApi = "infoflow/auth/cancellation"
    }
    
    //获取验证
    struct User {
        static let verifyCode = "cuser/user/verify-code"
    }
    
    //预览相关接口
    struct Preview {
        //其他信息
        static let previewOtherInfoApi = "infoflow/residence/preview"
        //基本资料
        static let previewBasicInfoApi = "infoflow/basics/get_basics"
        //主申请人信息
        static let previewMainApplicationInfoApi = "infoflow/order-information/preview_information"
        //家庭成员信息
        static let previewFamilyInfoApi = "infoflow/information/family"
        //学历/专业资格
        static let previewAcademicAndProfessionalQualificationInfoApi = "infoflow/education/preview"
        //工作经验
        static let previewWorkExpInfoApi = "infoflow/work/preview"
    }
    
    struct OSS {
        static let uploadApi = "oss/upload/storage"
        static let getPublicApi = "oss/storage/convertToPublicURL"
        static let getPublicUrlsApi = "oss/storage/batchConvertToPublicURL"
        static let getID = "ossv2/sts/auth"
    }
    
    struct OCR {
        static let cn = "ocr/id_card/recognize"
        static let hk = "ocr/permit/recognize"
        static let normal = "ocr/advanced/recognize"
    }
    
    //我的签字
    struct Signature {
        // 签字列表
        static let list = "infoflow/my-sign/list"
        // 签字详情
        static let detail = "infoflow/my-sign/detail"
        // 获取签署url
        static let pageUrl = "infoflow/sign/page-url"
        // 获取实名认证Url
        static let personalUrl = "infoflow/sign/personal-auth"
        // 获取签署状态
        static let callBack = "infoflow/sign/check-is-complete"
        // 签字上传
        static let upload = "infoflow/sign/upload"
        // 签字下载
        static let download = "infoflow/sign/download"
        // 发送邮箱
        static let sendMail = "infoflow/sign/send_mail"
        // 提交签字
        static let confirm = "infoflow/my-sign/confirm"
        // 查看合同
        static let look = "infoflow/sign/view-detail"
        // 查看签署状态
        static let signCallBack = "infoflow/sign/sign-callback"
        static let personal = "infoflow/sign/check-personal-status"
    }
    
    //我的文书
    struct Documents {
        // 文书列表
        static let listApi = "infoflow/my-doc/doc-list"
        // 文书详情
        static let detailApi = "infoflow/my-doc/doc-details"
        // 腾讯文档编辑
        static let temporaryUrlApi = "infoflow/my-doc/get_temporaryUrl"
        // 赴港计划书操作
        static let hkPlanApi = "infoflow/my-doc/hk-plan-edit"
        // 文书提交
        static let submitApi = "infoflow/my-doc/doc-submit"
        // 文书操作记录
        static let recordApi = "infoflow/my-doc/document-operation-record"
    }
    
    //我的证件
    struct Certificate {
        // 我的证件-状态数量统计
        static let statisticApi = "infoflow/certificate/statistic"
        
        // 清单列表
        static let documentListApi = "infoflow/certificate/certificate_document_list"
        
        // 证件列表
        static let certificateListApi = "infoflow/needUploadItems"
        
        // 证件上传
        static let certificateUploadApi = "infoflow/certificate/upload"
        
        //获取问答列表
        static let questionAndAnswerApi = "infoflow/answer-question/getAnswerQuestion"
    }
    
    // 我的方案
    struct Assessment {
        //方案计划
        static let applyPlanApi = "infoflow/assessment/apply_plan"
    }
    
    // 消息
    struct Message {
        // 获取未读消息列表
        static let unreadMsgListApi = "infoflow/unread-message"
        // 具体业务消息列表
        static let msgDetaiListApi = "infoflow/message/list/v2"
        // 标记消息已读
        static let readMsgApi = "infoflow/read-push"
        // 获取未读消息总数
        static let unreadTotalCountApi = "infoflow/unread-total"
        // 报备设备信息
        static let reportDeviceInfoApi = "infoflow/report-device-info"
    }
}
