//
//  BsBaseurlManager.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/17.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

// MARK: - 管理项目开发中需要使用到的域名地址
class YHBaseUrlManager {
    //单例
    static let shared = YHBaseUrlManager()
    
    //测试环境
    static let baseUrlTest : String = "https://test-app-go-api.galaxy-immi.com" //APP 使用域名
    //正式环境
    static let baseUrlRelease : String = "https://app-go-api.galaxy-immi.com"
    
    
    func curURL() -> String {
#if DEBUG
        return YHBaseUrlManager.baseUrlTest + "/"
#elseif TESTENV
        return YHBaseUrlManager.baseUrlTest + "/"
#else
        return YHBaseUrlManager.baseUrlRelease + "/"
#endif
    }
    
    //ossUrl
    func curOssURL() -> String {
        return YHConfigManager.shared.ossUrl
    }
    
    //h5Url
    func curH5URL() -> String {
        return YHConfigManager.shared.h5Url
    }
    
    //隐私协议 PrivacyAgreement
    func curPrivacyAgreementUrl() -> String {
        return "https://test-hkdiy-h5.galaxy-immi.com/superApp/ganglife"
    }
    
    //用户政策 UserItems
    func curUserItemsUrl() -> String {
        return "https://test-hkdiy-h5.galaxy-immi.com/superApp/service"
    }
}
