//
//  YHTravelCertificateUsageTipsView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/4.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHTravelCerTipsItemView: UIView {
    
    lazy var dotView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0x0046B4, alpha: 0.16)
        v.layer.cornerRadius = 1.0
        return v
    }()
    
    lazy var textLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .left
        label.numberOfLines = 0
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(dotView)
        self.addSubview(textLabel)
        
        dotView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(8)
            make.width.height.equalTo(5)
        }
        
        textLabel.snp.makeConstraints { make in
            make.left.equalTo(dotView.snp.right).offset(8)
            make.top.right.equalTo(0)
            make.bottom.equalTo(-12)
        }
    }
    
    func update(title: String, desc: String) {
        
        let aa: ASAttributedString = .init("\(title)", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("\(desc)", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        let result = aa + bb
        textLabel.attributed.text = result
    }
}

class YHTravelCertificateUsageTipsView: UIView {

    lazy var markView: UIView = {
        let view = UIView()
        view.backgroundColor = .init(hex: 0x000000, alpha: 0.68)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = 6.0
        view.backgroundColor = .white
        return view
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0x94A3B824, alpha: 0.14)
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "温馨提示"
        label.textAlignment = .center
        label.font = .PFSC_M(ofSize: 17)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.text = "旅行证件使用规范："
        label.textAlignment = .left
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var ruleContentView: UIView = {
        let v = UIView()
        return v
    }()
    
    lazy var bottomBtn: UIButton = {
        let btn = UIButton()
        btn.layer.cornerRadius = 3.0
        btn.setTitle("我已知悉", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = .brandMainColor
        btn.titleLabel?.font = .PFSC_R(ofSize: 14)
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    static func alertView() -> YHTravelCertificateUsageTipsView {
        let view = YHTravelCertificateUsageTipsView(frame: UIScreen.main.bounds)
        return view
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func didBottomBtnClicked() {
        dismiss()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(markView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(subtitleLabel)
        whiteContentView.addSubview(ruleContentView)
        whiteContentView.addSubview(bottomBtn)
        
        markView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.height.equalTo(52)
            make.left.right.top.equalToSuperview()
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(titleLabel)
            make.height.equalTo(0.5)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(18)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(20)
        }
        
        ruleContentView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(subtitleLabel.snp.bottom).offset(12)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(45)
            make.top.equalTo(ruleContentView.snp.bottom).offset(20)
            make.bottom.equalTo(-17)
        }

        let arr1 = ["护照：", "港澳通行证："]
        let arr2 = ["适用于外籍申请人，或在紧临申请之前已在海外连续居住满 12 个月的中国籍申请人，获批后需使用护照入境香港激活签证。",
                    "适用于紧临申请之前未在海外连续居住满 12 个月的中国籍申请人，获批后需使用港澳通行证入境香港激活签证。"]
        
        var lastView: YHTravelCerTipsItemView?
        for (index, text) in arr1.enumerated() {
            let view = YHTravelCerTipsItemView(frame: .zero)
            view.update(title: arr1[index], desc: arr2[index])
            ruleContentView.addSubview(view)
            view.snp.makeConstraints { make in
                make.left.right.equalTo(0)
                if let last = lastView {
                    make.top.equalTo(last.snp.bottom)
                } else {
                    make.top.equalTo(0)
                }
                
                if index == arr1.count-1 {
                    make.bottom.equalTo(0)
                }
            }
            lastView = view
        }
    }
}
