//
//  YHVisaRenewalPayTipsCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalPayTipsCell: YHVisaRenewalPayInfoBaseCell {

    static let cellReuseIdentifier = "YHVisaRenewalPayTipsCell"
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 13)
        label.textColor = .mainTextColor50
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        label.textAlignment = .center
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(detail: String) {
        infoDetailLabel.text = detail
    }
}

extension YHVisaRenewalPayTipsCell {
    private func setupUI() {
        updateInnerCellCorner(.bottom)
        innerContainerView.addSubview(infoDetailLabel)
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(12)
            make.bottom.equalToSuperview().offset(-16)
            make.centerX.equalToSuperview()
            make.left.greaterThanOrEqualToSuperview().offset(16)
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
    }
}
