//
//  YHAIChatInputShadowView.swift
//  galaxy
//
//  Created by Dufet on 2024/12/2.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIChatInputShadowView: UIView {

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupShadow()
    }
        
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupShadow()
    }
    
    private func setupShadow() {
     
        let shadowPath = UIBezierPath(roundedRect: bounds, cornerRadius: 12)
        layer.shadowPath = shadowPath.cgPath
        
        layer.shadowColor = UIColor(red: 0.35, green: 0.432, blue: 0.556, alpha: 0.12).cgColor
        layer.shadowOpacity = 1
        layer.shadowRadius = 20
        layer.shadowOffset = CGSize(width: 0, height: 0)
    }
        
    override func layoutSubviews() {
        super.layoutSubviews()
        // 确保在布局更新时更新阴影路径
        setupShadow()
    }

}
