//
//  YHServiceOrderAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHServiceOrderAlertView: UIView {
    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var lineView: UIView!
    var knowButton: UIButton!
    var measageLabel: UILabel!
    var subMeasageLabel: UILabel!

    static func show() {
        let view = YHServiceOrderAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(401)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "温馨提示"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.height.equalTo(21)
            make.right.equalTo(-21)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.width.height.equalTo(24)
            make.top.equalTo(16)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(52)
            make.height.equalTo(1)
        }
        
        knowButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("我知道了", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(knowButton)
        knowButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.height.equalTo(48)
            make.bottom.equalTo(-29)
        }
        
        measageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(measageLabel)
        measageLabel.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(73)
        }
        
        subMeasageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(subMeasageLabel)
        subMeasageLabel.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(157)
        }
        
        let a: ASAttributedString = .init("尊敬的银河用户，为了您的信息安全，银河港生活APP服务订单默认仅关联【签约手机号】", .font(UIFont.PFSC_R(ofSize: 15)), .foreground(UIColor.mainTextColor.withAlphaComponent(0.7)))
        
        let bb: ASAttributedString = .init("*如您已签约银河服务，请改用签约手机号重新登录", .font(UIFont.PFSC_R(ofSize: 15)), .foreground(UIColor(hex: 0x8893a2)))

        measageLabel.attributed.text = a
        subMeasageLabel.attributed.text = bb
        
        knowButton.backgroundColor = .brandMainColor
        knowButton.addYinHeGradualLayer()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func goNext() {
        dismiss()
    }
}

extension YHServiceOrderAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
